/*
 * TSK_TEMP.CPP
 */
#include "mbed.h"
#include "rtos.h"

#include "DS1620.h"

#include "tsk_main.h"
#include "tsk_temp.h"


struct temp_data_struct temp_data;

static  DS1620 ds1620Sensor(PB_4, PB_10, PB_3);


uint32_t initDS1620Temp(void const *args) {
    
    temp_data.temperature = 10.0f;
    temp_data.temp_raw = 10;
    
    ds1620Sensor.setSerialClockFrequency(freq250k);
    
    if ((ds1620Sensor.readConfig() & 0x03) != 0x03) {
        ds1620Sensor.writeConfig(0x03);
    }
    
    if ((ds1620Sensor.readConfig() & 0x03) != 0x03) {
        return 0;
    }
    
    return 1;
}

void temp_thread(void const *args) {

    float temp;
    uint32_t temp_raw;
    
    while (true) {
        ds1620Sensor.startConversion();
    
        // Wait for conversion completion (Tconv = 750 ms typ)
        Thread::wait(750);
        while (!(ds1620Sensor.readConfig() & 0x80))
            Thread::wait(10);
                
        temp = ds1620Sensor.getHighResolutionTemperature();
        temp_raw = ds1620Sensor.readTemperatureRaw();

        mutexTemp.lock();
        temp_data.temperature = temp;
        temp_data.temp_raw = temp_raw;
        mutexTemp.unlock();
        
        Thread::wait(1250);
    }
}
