#include "mcp4725.h"
#include "mbed.h"

MCP4725::MCP4725(PinName sda, PinName scl, BusFrequency bus_frequency, int device_address_bits): _i2c_interface(sda, scl)
{
    //Set the frequency
    int freq=0;
    switch(bus_frequency)
    {
        case Standard100kHz:
            freq = 100000;
            break;
        case Fast400kHz:
            freq = 400000;
            break;
        case HighSpeed3_4Mhz:
            freq = 3400000;
            break;
    }
    _i2c_interface.frequency(freq);
    
    // Assemble the full I2C device address.
    _device_address = 0xC4; // Prime the full device address with the device code.
    //_device_address |= (device_address_bits<<1);
}

int MCP4725::read(enum PowerMode* mode, enum PowerMode* mode_eeprom, int* dac_value, int* dac_value_eeprom, bool* eeprom_write_in_progress)
{
    char data[5];
    int result;
    
    // Read the raw data from the device.
    result = _i2c_interface.read(_device_address, data, sizeof(data)/sizeof(*data), false);
    
    // Parse the raw data, extracting our fields. Refer to MCP4725 ref manual, section 6.2
    if (result == 0)
    {
        *eeprom_write_in_progress = (data[0] & 0x80)? false:true;
        
        *mode = (enum PowerMode) ((data[0] & 0x06)>>1);
        
        *dac_value  = (data[1]<<4) + (data[2]>>4);
        
        *mode_eeprom = (enum PowerMode)((data[3] & 0x60)>>5);
        
        *dac_value_eeprom = ((data[3] & 0x0F) <<8) + data[4];
    }
     
    return result;
}



int MCP4725::write(enum PowerMode mode, int dac_value, bool writeToEeprom)
{
    char data[3]={0};
    int write_command;
    
    //Which write command are we to use?
    if (writeToEeprom == true)
    {
        //Write DAC Register and EEPROM
        write_command = 3;
    }
    else
    {
        //Write DAC Register
        write_command = 2;
    }
    
    //Assemble our three bytes of data - Refer to MCP4725 ref manual, section 6.
    data[0] = (write_command <<5) | ((int)mode<<1);
    data[1] = (dac_value>>4);
    data[2] = (dac_value<<4);
    
    // Now write them to the device.
    return _i2c_interface.write(_device_address, data, sizeof(data)/sizeof(*data), false);
}