#include "Led_Lcd.h"

LedLcd::LedLcd(unsigned char ucColumnIndex){
    
    ucLedPos = ucColumnIndex*80;
    lcd.Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&Font24);    
    lcd.SetBackColor(LCD_COLOR_RED);
    //lcd.SetTextColor(LCD_COLOR_GREEN);
    
    //for(unsigned char ucRectNumber = 0; ucRectNumber < 4; ucRectNumber++){
      //  lcd.DrawRect(ucLedPos, ucRectNumber*80, 80, 80);
    //}
}

void LedLcd::On(unsigned char ucLedIndex){
    
    unsigned char ucKeyNumber[2];
    
    for(unsigned char ucKeyCounter = 0; ucKeyCounter < 4; ucKeyCounter++){
        if(ucLedIndex == ucKeyCounter){
            lcd.SetTextColor(LCD_COLOR_YELLOW);    
        }
        else{
            lcd.SetTextColor(LCD_COLOR_BLUE);
        }
        lcd.FillRect(ucLedPos+1, ucKeyCounter*80 + 1, 79, 79);
        lcd.SetTextColor(LCD_COLOR_WHITE);
        sprintf((char*)ucKeyNumber, "%d", ucKeyCounter);
        lcd.DisplayStringAt(ucLedPos, ucKeyCounter*80, (uint8_t *) &ucKeyNumber, LEFT_MODE);
        lcd.SetTextColor(LCD_COLOR_GREEN);
        lcd.DrawRect(ucLedPos, ucKeyCounter*80, 80, 80);
    }
}  