#include "Keyboard_Ts.h"

KeyboardTs::KeyboardTs(unsigned char ucColumnIndex){
    ucLeftBoundary = ucColumnIndex*80;
    ucRightBoundary = ucColumnIndex*80 + 80;
}

enum KeyboardState KeyboardTs::eRead(){
    ts.GetState(&TS_State);
    if (TS_State.TouchDetected & (TS_State.X >= ucLeftBoundary) & (TS_State.X < ucRightBoundary)){ 
        if(TS_State.Y <80){
            return BUTTON_0;
        }
        else if(TS_State.Y <160){
            return BUTTON_1;    
        }
        else if(TS_State.Y <240){
            return BUTTON_2;
        }
        else{
            return BUTTON_3;   
        }
    }
    else{
        return RELASED;
    }         
}
