#include "mbed.h"
#include "PinDetect.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
//#include "rtos.h"
// must import Cookbook PinDetct library into project
// URL: http://mbed.org/users/AjK/libraries/PinDetect/lkyxpw
 
PinDetect pb1(p24);
PinDetect pb2(p25);
AnalogIn pot(p20);
uLCD_4DGL uLCD(p9, p10, p11);
Speaker mySpeaker(p26);

float r;
float g;
float b;

float t;

//Class to control an RGB LED using three PWM pins ---------------------------------------
class RGBLed
{
public:
    RGBLed(PinName redpin, PinName greenpin, PinName bluepin);
    void write(float red,float green, float blue);
private:
    PwmOut redpin;
    PwmOut greenpin;
    PwmOut bluepin;
};
 
RGBLed::RGBLed (PinName red, PinName green, PinName blue)
    : redpin(red), greenpin(green), bluepin(blue)
{
    //50Hz PWM clock default a bit too low, go to 2000Hz (less flicker)
    redpin.period(0.0005); //?////////////////////////////////////////////////
    greenpin.period(0.0005);
    bluepin.period(0.0005);
}
 
void RGBLed::write(float red,float green, float blue)
{
    redpin = red;
    greenpin = green;
    bluepin = blue;
}
//class could be moved to include file
 
 
//Setup RGB led using PWM pins and class
RGBLed myRGBled(p21,p22,p23); //RGB PWM pins //-------------------------------------- RGB

void song1() {
    //first verse using lower octave because the speaker has too much sauce
    mySpeaker.PlayNote(523.251,2.0/t,0.1);
    mySpeaker.PlayNote(493.883,0.5/t,0.1);
    mySpeaker.PlayNote(523.251,0.5/t,0.1);
    mySpeaker.PlayNote(587.330,1.0/t,0.1);
    mySpeaker.PlayNote(440.000,2.0/t,0.1);
    mySpeaker.PlayNote(391.995,2.0/t,0.1);
    
    mySpeaker.PlayNote(349.228,2.0/t,0.1);
    mySpeaker.PlayNote(329.628,0.5/t,0.1);
    mySpeaker.PlayNote(349.228,0.5/t,0.1);
    mySpeaker.PlayNote(391.995,1.0/t,0.1);
    mySpeaker.PlayNote(369.994,2.0/t,0.1);
    mySpeaker.PlayNote(391.995,2.0/t,0.1);
    
    mySpeaker.PlayNote(0.0,0.5/t,0.0); //rest then repeat
}

void song2() {
    //first verse using lower octave because the speaker has too much sauce
    mySpeaker.PlayNote(493.883,1.0/t,0.1);
    mySpeaker.PlayNote(554.365,1.0/t,0.1);
    mySpeaker.PlayNote(369.994,1.0/t,0.1);
    mySpeaker.PlayNote(440.000,0.5/t,0.1);
    mySpeaker.PlayNote(493.883,1.0/t,0.1);
    mySpeaker.PlayNote(554.365,1.0/t,0.1);
    mySpeaker.PlayNote(369.994,1.0/t,0.1);
    mySpeaker.PlayNote(440.000,1.0/t,0.1);
    mySpeaker.PlayNote(440.000,0.5/t,0.1);
    
    mySpeaker.PlayNote(659.255,1.0/t,0.1);
    mySpeaker.PlayNote(554.365,1.0/t,0.1);
    mySpeaker.PlayNote(493.883,1.0/t,0.1);
    mySpeaker.PlayNote(554.365,0.5/t,0.1);
    mySpeaker.PlayNote(493.883,1.0/t,0.1);
    mySpeaker.PlayNote(440.000,1.0/t,0.1);
    mySpeaker.PlayNote(493.883,1.0/t,0.1);
    mySpeaker.PlayNote(554.365,0.5/t,0.1);
    mySpeaker.PlayNote(493.883,0.5/t,0.1);
    
    mySpeaker.PlayNote(0.0,0.5/t,0.0); //rest then repeat
}

// Global count variable
int count=1;
// Callback routine is interrupt activated by a debounced pb1 hit
void pb1_hit_callback (void) {
    if(count < 5){
        count++;
    }
}
// Callback routine is interrupt activated by a debounced pb2 hit
void pb2_hit_callback (void) {
    if(count > 0){
        count--;
    }
}

int main() {
 
    // Use internal pullups for pushbutton
    pb1.mode(PullUp);
    pb2.mode(PullUp);
    // Delay for initial pullup to take effect
    wait(.05);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    //Blink myled in main routine forever while responding to pb changes
    // via interrupts that activate the callback counter function
    
    int colors[1280] = {
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff020100, 0xff1e1b0b, 0xff010100, 0xff000000, 0xff5d5d5d, 0xffb8b8b8, 0xff1f1f21, 0xff040200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff3d3817, 0xffc3ba4f, 0xff686129, 0xff000000, 0xff000000, 0xff646464, 0xff777777, 0xff030407, 0xff0d0a02, 0xffd4ce58, 0xffdcd45a, 0x00000000, 0x00000000, 0x00000000, 0xff3a382b, 0xffa4a07d, 0xff5e5a43, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff817b34, 0xffffff6c, 0xffdfd95c, 0xff080703, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff060402, 0xffcdc352, 0xffffff77, 0xffc2b84e, 0x00000000, 0xff4e4d3e, 0x00000000, 0x00000000, 0x00000000, 0xff5e5a43, 0x00000000, 0x00000000, 0xff5e5a43, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffb3a846, 0xffffff6d, 0xffffff6f, 0xff7c7632, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff3d3918, 0xfff2e85c, 0xfffeed61, 0xfff2e35e, 0xff454126, 0x00000000, 0x00000000, 0xff494938, 0xff5e5a43, 0x00000000, 0xff5a5943, 0xff79775e, 0x00000000, 0xff343122, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffbdad49, 0xfffff065, 0xffffec64, 0xfffffd6b, 0xff655d27, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff151203, 0xffcbbe3d, 0xffe9e193, 0xffc3b876, 0xfffff35c, 0xff78743e, 0x00000000, 0xff5f5b48, 0xff28271c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff1f1d16, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffa1973f, 0xffe1d258, 0xfff8e561, 0xfffce862, 0xfffff668, 0xffb6ad49, 0xff010000, 0xff000000, 0xff000000, 0xff000000, 0xff2e2805, 0xffc5b64b, 0xffe2da98, 0xffaeb0bd, 0xffd5c86b, 0xfffff45f, 0xff6d6838, 0xff514f48, 0xff605f45, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff828263, 0xff1d1d14, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffbeb24b, 0xffdacb56, 0xffffef65, 0xfffbe762, 0xfffce862, 0xfffff668, 0xffb9ae4a, 0xff5c5725, 0xff676126, 0xff998c38, 0xffc7bd7a, 0xffcecdc3, 0xffc8c7bc, 0xffc5b958, 0xfffff45f, 0xffe7d95a, 0xff312f1d, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff474738, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffa1943e, 0xffcaba4e, 0xfff0e460, 0xffffec64, 0xfffbe762, 0xfffbe762, 0xfffde963, 0xfffffb6a, 0xffffff6b, 0xffdcd763, 0xffaba579, 0xffcac5ab, 0xffcfc470, 0xfff4e156, 0xfffff15e, 0xffffff6c, 0xff958f3c, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff363526, 0xff302d20, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffad9e43, 0xffd3c553, 0xfffff266, 0xfffbe762, 0xfffbe862, 0xfffbe762, 0xfffeeb63, 0xfffbe962, 0xffcdbd4e, 0xffa3984c, 0xffd6cb61, 0xfffff65c, 0xffffff66, 0xfffff868, 0xfffff768, 0xffcac151, 0xff777251, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff474733, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffa79940, 0xffe5d85b, 0xfffff066, 0xfffae661, 0xfffbe762, 0xfffeeb63, 0xfff5e25f, 0xffe1ce56, 0xffebdb5c, 0xffffff6b, 0xfffffd67, 0xffc4bc4f, 0xff7e7632, 0xff4a461e, 0xff292710, 0xff070401, 0xff2b2d32, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff444235, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff978a3a, 0xfffaeb63, 0xfffff568, 0xfffff568, 0xfffffb6a, 0xfffce962, 0xffeede5d, 0xfffffc6a, 0xfffff668, 0xffa49c42, 0xff3e3818, 0xff020100, 0xff000000, 0xff000000, 0xff706c2e, 0xffbcb54c, 0xff5e5725, 0x00000000, 0x00000000, 0xff97956e, 0xff6d6d57, 0xff4a4a3a, 0xff272317, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffa0913e, 0xffc7bb4f, 0xfff0e05f, 0xffd6c955, 0xff9a903c, 0xffd1c352, 0xffe2dd5e, 0xffb8b04a, 0xff403c19, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff5a5624, 0xffffff6f, 0xffffff6e, 0xfffff868, 0xff645c25, 0xff5e5a43, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff7f7532, 0xffd5c955, 0xff2c2710, 0xff000000, 0xff19170a, 0xff1d190b, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff7d7732, 0xffffff74, 0xfffff668, 0xfffff367, 0xfffcf065, 0xffbbaf49, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xfffff96c, 0xffa39e44, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff181609, 0xff776f2f, 0xffb5aa48, 0xffffff6e, 0xfffff668, 0xffffff6b, 0xffb2a847, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffbfb54d, 0xffeae05f, 0xff524c20, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0xff7e7933, 0xffdcca55, 0xffffff6c, 0xffe9e361, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffa5973f, 0xffd0c352, 0xffd2c855, 0xff1e1c0b, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff090602, 0xffa49c42, 0x00000000, 0x00000000, 0xff837e37, 0xffbaac48, 0xfffff96a, 0xffcfcb56, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff645926, 0xffeae360, 0xffffff71, 0xff8d8136, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff1f1c0b, 0xffccc856, 0xffffff75, 0xffe2d75c, 0xffa89c40, 0xffffff7a, 0xffe0d85d, 0xff837b33, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff6c662c, 0xffb2a947, 0xff908738, 0xff141208, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff1d1a0b, 0xffb4aa49, 0xff807833, 0xffdad058, 0xfffff366, 0xffbbad49, 0xffaba344, 0xff6c652b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff898036, 0xff22200d, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff131107, 0xffc9c253, 0xfffaf56b, 0xff171308, 0xff231f0d, 0xffdece57, 0xff8d8237, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xffd4cd59, 0xffded85d, 0xff48421b, 0xff171408, 0xff141007, 0xff4c471e, 0xffd4ca55, 0xffffff75, 0xffcbc653, 0xff080502, 0xff000000, 0xffa69e43, 0xfffcf66b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff766c2b, 0xfffffe6c, 0xffffff71, 0xffe2dc5d, 0xffddd75b, 0xfffffc6b, 0xffffff71, 0xfff5ec64, 0xff413c19, 0xff000000, 0xff000000, 0xff71692c, 0xffffff76, 0xffa59d42, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff6e662b, 0xffdfd95b, 0xffffff6d, 0xffffff6f, 0xfffcf869, 0xffc5bf50, 0xff393516, 0xff000000, 0xff000000, 0xff000000, 0xff9e933e, 0xffffff75, 0xff928c3b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff120f06, 0xff363315, 0xff46421c, 0xff363215, 0xff080602, 0xff000000, 0xff000000, 0xff000000, 0xff45401b, 0xfffcf166, 0xffffff70, 0xff615b26, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff1c180a, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff5c5524, 0xffede25f, 0xffffff70, 0xffcec955, 0xff0e0b05, 0xff030200, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff6b6329, 0xffb8b14a, 0xff8e8739, 0xff837b35, 0xff24210e, 0xff000000, 0xffd6cd57, 0xffffff78, 0xffebe360, 0xff353115, 0xff000000, 0xff948d3c, 0xff615d28, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff585323, 0xffd2cb57, 0xffffff73, 0xffb9b24d, 0xff010000, 0xff847e35, 0xffc2bc4f, 0xff2c2811, 0xff000000, 0xff1a1709, 0xfffffa6a, 0xff96913e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0xff564d20, 0xff817832, 0xff1b170a, 0xff080603, 0xff020000, 0xff000000, 0xff000000, 0x00000000, 0xff6d682d, 0xffb3aa48, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff574f21, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff0f0d01, 0xff6b6222, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff787878, 0xff8f8f8f, 0xff454545, 0xff4f4f50, 0xff545450, 0xff797662, 0xff5e5e5e, 0x00000000, 0x00000000, 0x00000000, 0xff161408, 0xff554e1e, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff000000, 0xff313131, 0xff404040, 0xff2d2d2d, 0xff3c3c3b, 0xff3e3e40, 0xff404147, 0xff353537, 0xff000000, 0xff000000, 0xff000000, 0xff131106, 0xff6e6739, 0xff333332, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0xff000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff4d4d4d, 0xffaaaaaa, 0xff4e4e4e, 0xff3a3a3a, 0xff494a4c, 0xff575861, 0xff46484a, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 
        0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0xff757575, 0xffbfbfbf, 0xffa4a4a4, 0xff7b7b7b, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000, 0x00000000
    };
    uLCD.BLIT(48, 44, 32, 40, colors);
    while (1) {
        r = pot.read();
        g = pot.read();
        b = pot.read();
        if (count < 4)
            b = 0;
        if (count < 3)
            g = 0;
        if (count < 2)
            r = 0;
        if(pot.read() > 0.9 && count > 4){
            uLCD.locate(0,12);
            uLCD.printf("YOU GRADUATED!!!");
            t = 2.5;
            song1();
            count--;
        }
        if(pot.read() < 0.1 && count < 1){
            uLCD.locate(0,12);
            uLCD.printf("Sadness.........");
            t = 2.9166;
            song2();
            count++;
        }
        
        myRGBled.write(r,g,b);
        uLCD.locate(0,0);
        uLCD.printf("Year: %i\n", count);
        uLCD.printf("Future Brightness:%f\n", pot.read());
    }
}