/**
* All the code associated to run the mbed as a locker.
* Link with hub
* Link with battery
*/
#include "mbed.h"
#include "utils.h"
#include "NRF2401P.h"
#define debug 

// Flags
unsigned char flagNrfReceive = 0;
// Variables
char nrfStateL;
float currentMaxL = 1.5; // Maximum current that each cube can consume.

// tx nRF2401

long long addrHub=0xBBBBBBBBBB;
extern NRF2401P nrf1;
extern int channel;
InterruptIn nrf1IntL(PTC18); // IRQ of nRF24

// -----------------------------------------------------------------------------
// Interupt routines
// -----------------------------------------------------------------------------
/**
*  Interrupt from nrf
*
*   RX_DR   Data Ready RX FIFO interrupt.
*   TX_DS   Data Sent TX FIFO interrupt. Asserted when packet transmitted on TX. 
*    -      - If AUTO_ACK is activated, this bit is set high only when ACK is received.
*   MAX_RT  Maximum number of TX retransmits interrupt (tx failed)
*   TX_FULL TX FIFO full flag.
*/
void intNrfL(){
    spiNrf();
    flagNrfReceive = nrf1.checkStatus();
    if ((flagNrfReceive >>6) &0x01) { // RX_DR - RX ready
        flagNrfReceive = 1;
    }
}

void doNrfL(){
    int width;
    char data[33];
#ifdef debug
    printf("intNrf %02X %s \n\r",nrf1.status, nrf1.statusString());
#endif
    spiNrf();
    char pipe = (nrf1.checkStatus() >> 1) & 7;
    width= nrf1.getRxData(data);
    data[width]='\0';
    // Now check which pipe
    if (pipe==0) { //The hub
        // Check command
        switch (data[0]){
        case ('T'):{ // Time signal
                time_t newTime;
                sscanf (data,"%*c %x",&newTime);
                set_time(newTime);
                printf("  New Time %s\n\r", ctime(&newTime));
                break;
            }
        case ('I'):{ // maxCurrent
                sscanf (data,"%*c %x",&currentMaxL);
                printf("  New Current %4.2f\n\r",currentMaxL);
                break;
            }
        }
    }
    printf("==>RX Pipe %d [%d]:%s: %s\n\r",pipe, width, data, nrf1.statusString());
    nrf1.clearStatus();
}
// -----------------------------------------------------------------------------
// Initializaton
// -----------------------------------------------------------------------------

/**
* Sets up the interrupts for the locker
*/
void initInteruptsLocker(){
    nrf1IntL.fall(&intNrfL); // attach nrf
}


/**
* Initialise for a locker
*/
void initialiseLocker(FILE *fp){
#ifdef debug
    printf("Initialise Locker\n\r");
#endif

    // Read in hub address and channel
    if (fscanf (fp,"%x %*c %*s",&channel )!=1) writeError("Locker config: cannot read channel");
    if (fscanf (fp,"%llx %*c %*s",&addrHub )!=1) writeError("Locker config: cannot read hub address");

#ifdef debug
    printf("  Channel:%x, Hub Address %llx \n\r",channel, addrHub);
#endif
    // Setup nrf

#ifdef debug
    printf("Steup doNrf \n\r");
#endif
    spiNrf();
    nrf1.quickRxSetup(channel, addrHub);
#ifdef debug
    nrf1.printDetails();
    nrf1.checkStatus();
    printf("Setup doNrf complete [nrf:%s]\n\r",nrf1.statusString());
#endif

    // Setup interupts
    initInteruptsLocker();

}
// Interupt routines


// Loop through slow routines

void loopLocker(){
    if (flagNrfReceive){
        doNrfL();
        flagNrfReceive = 0;
    }

}