/**
* Useful utils
*/
#include "mbed.h"
#include "pinmap.h"
#include "utils.h"

DigitalOut ledError(LED_RED,ledOFF);
/**
* turns SPI on for Nrf
*/
void spiNrf()
{
    //sd.deselect();
    pin_function(PTE1, 1);  //pin function 1 is GPIO
    pin_function(PTD7, 7); //Set SD_MISO as SPI, this is the same as the last number in those tables
}

/**
* Turns SPI on for SD card
*/
void spiSD()
{
    //sd.select();
    pin_function(PTE1 , 7);  //Set SD_MISO as SPI, this is the same as the last number in those tables
    pin_function(PTD7, 1); //pin function 1 is GPIO
}

/**
* Flashes the red led and writes error message to stdout for ever.
*/
void writeError( char *msg ){
 
    while (1){
        ledError = ledON;
        printf("ERROR: %s\n\r",msg);
        wait (0.1);
        ledError = ledOFF;
        wait (0.5);
          ledError = ledON;
        wait (0.2);
        ledError = ledOFF;
        wait (3.9);
    }
    
}