/**
* All the code associated to run the mbed as a battery.
* Link with locker
*/
#include "mbed.h"
#include "utils.h"
#define debug 

// Flags
// Variables
// tx nRF2401

long long addrLocker=0xBBBBBBBBBB;
extern int channel;

// Initializaton
/**
* Initialise for a battery
* fp is the config file if additonal information is needed.
*/
void initialiseBattery(FILE *fp){
#ifdef debug
    printf("Initialise Battery\n\r");
#endif

    // Read in hub address and channel
    if (fscanf (fp,"%x %*c %*s",&channel )!=1) writeError("Battery config: cannot read channel");
    if (fscanf (fp,"%llx %*c %*s",&addrLocker )!=1) writeError("Battery config: cannot read address");

#ifdef debug
    printf("  Channel:%x,  Address %llx \n\r",channel, addrLocker);
#endif


}
// Interupt routines


// Loop through slow routines

void loopBattery(){

}