/**
* This is a multi-purpose mbed. Duiring initialisation it reads the config file and then configures the mbed appropriately.
* L Locker
* H main Hub
* B Battery
*/
#include "mbed.h"
#include "SDFileSystem.h"
#include "NRF2401P.h"
#include "utils.h"
#include "battery.h"
#include "hub.h"
#include "locker.h"
#include "test.h"
#define debug 

// Defines the role of mbed
char role;
unsigned int version = 1453505344; // Linux epoch time
unsigned int sdVersion;
int id;
int channel;
char txBuff[100];

// Sd card
SDFileSystem sd(PTE3, PTE1, PTE2, PTE4, "sd");

// nrf
NRF2401P nrf1(PTD6,PTD7, PTD5,PTD4, PTC12); //mosi, miso, sclk, csn, ce)
/**
* Reads config file and configures the mbed
*/
void initialise()
{
    char * name = "/sd/config.ini";
    FILE *fp;

    // Initialise the SD card
    spiSD();
    sd.large_frames(false);
    sd.mount();
    wait(0.1);
#ifdef debug
    printf("  SD MOUNTED Card role: %d  Capacity: %.1fMB\n\r", sd.card_type(),(sd.disk_sectors() * 512) / 1048576.0);
#endif


    //Configuration
#ifdef debug
    printf("Reading config file...\n\r");
#endif
    fp = fopen(name, "r");
    if (fp == NULL) {
        writeError ("Config file cannot be read");
    }
    if (fscanf (fp,"%c %*c %*s",&role )!=1) writeError("Config: cannot read role");
    if (fscanf (fp,"%d %*c %*s",&sdVersion )!=1) writeError("Config: cannot read version");
    if (fscanf (fp,"%d %*c %*s",&id )!=1) writeError("Config: cannot read id");
#ifdef debug
    printf("  Type:%c, Version %u, ID %d\n\r",role,sdVersion,id);
#endif
    switch (role){
    case('B'): { // Battery
            initialiseBattery(fp);
            break;
        }
    case('H'): { // Hub
            initialiseHub(fp);
            break;
        }
    case('L'): { // Locker
            initialiseLocker(fp);
            break;
        }
    case('T'): { // Test
            initialiseTest(fp);
            break;
        }
    default:{
            writeError ("Type declared in config not available.");
        }

    }
    fclose (fp);
}

/**
* main loop. Set up timers and interupts then wait
*/
int main()
{
    struct tm * timeInf = localtime(&version);
    printf("\n\r SOLAR NANO GRID CONTROLLER. Version %04d-%02d-%02d %02d:%02d \n\r", timeInf->tm_year+1900,timeInf->tm_mon+1,timeInf->tm_mday,timeInf->tm_hour, timeInf->tm_sec);
    //
    // Read config and initialise
    //
#ifdef debug
    printf("\n\rInitialise \n\r");
#endif
    initialise();
#ifdef debug
    printf("\n\r> START LOOP\n\r");
#endif
    while (true) {
        // do slower routines
        switch (role){
        case('B'): { // Battery
                loopBattery();
                break;
            }
        case('H'): { // Hub
                loopHub();
                break;
            }
        case('L'): { // Locker
                loopLocker();
                break;
            }
        case('T'): { // Test
                loopTest();
                break;
            }
        default:{
                writeError ("Type declared in config not available.");
            }
        }

    }
}