#include "mbed.h"
#include "C12832.h"
#include "Log.h"
#include "TcpDaemon.h"
#include "StatusIndicator.h"
#include "Configuration.h"

#define LCD_LINE_HEIGHT 12
#define CONFIG_FILE "/local/brails.cfg"

Serial pc(USBTX,USBRX);
DigitalOut error_led(LED1);
C12832 lcd(p5, p7, p6, p8, p11);

using namespace MachineVision;

void setLcdServerInfo(char * ip) {
//    lcd.cls();
//    lcd.locate(0,0);
//    lcd.printf("IP: %s", ip);
//    lcd.locate(0,14);
//    lcd.printf("Port: %d", TCP_SERVER_PORT);
}

int main (void) {
    pc.baud(115200);

    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Starting ...");
    
    // Read config from local filesystem
    LocalFileSystem local("local");
    Configuration config;

    if (config.readFromFile(&local, CONFIG_FILE)) {
        Log::v("Using config:\r\n\tDHCP: %d\r\n\tIP: %s\r\n\tNETMASK: %s\r\n\tGATEWAY: %s\r\n\tTCP_PORT: %d\r\n", config.useDhcp(), config.getIpAddress(), config.getNetmask(), config.getGateway(), config.getTcpPort());
    } else {
        // Create default config
        Log::w("Creating default config file\r\n");
        if (config.writeConfiguration(&local, CONFIG_FILE)) {
            Log::w("Created default config file\r\n");
            
            // Try a read now
            if (config.readFromFile(&local, CONFIG_FILE)) {
                Log::v("Using config:\r\n\tDHCP: %d\r\n\tIP: %s\r\n\tNETMASK: %s\r\n\tGATEWAY: %s\r\n\tTCP_PORT: %d\r\n", config.useDhcp(), config.getIpAddress(), config.getNetmask(), config.getGateway(), config.getTcpPort());
            } else {
                Log::w("Still could not read config. Giving up. Check filesystem as it may be corrupt.\r\n");
                error("Still could not read config. Giving up. Check filesystem as it may be corrupt.\r\n");
            }
        } else {
            Log::w("Creating default config file failed. Check filesystem as it may be corrupt.\r\n");
        }
    }

    while (true) {
        // Setup ethernet interface    
        EthernetInterface eth;
        Log::v("Bringing ethernet interface online\r\n");
        
        int success = 0;
        if (config.useDhcp()){
            success = eth.init();
        } else {
            success = eth.init(config.getIpAddress().c_str(), config.getNetmask().c_str(), config.getGateway().c_str());
        }
        
        if (success < 0 || eth.connect() < 0) {    // Default timeout of 15 seconds
            Log::w("Could not bring ethernet interface online\r\n");
            setLcdServerInfo("No ip address");
        } else {
            Log::v("IP Address is %s\r\n", eth.getIPAddress());
            
            // Set ip on LCD
            setLcdServerInfo(eth.getIPAddress());
        
            // Start the daemon
            PlcStatusIndicator status_indicator(p21);
            TcpDaemon daemon(config.getTcpPort(), LED2, LED3, &status_indicator);
            Log::v("TCP daemon listening @ TCP_SERVER_PORT = %d\r\n", config.getTcpPort());
            daemon.startListening();
        }
        
        wait(5);
    }
}
