#include "Indication.h"
#include "RGBStatusIndicator.h"

namespace MachineVision {
    
    RGBStatusIndicator::RGBStatusIndicator(PinName red_pin, PinName green_pin, PinName blue_pin)
        : rOut(red_pin), gOut(green_pin), bOut(blue_pin) {
        initializeRGB();       
    }
    
    void RGBStatusIndicator::initializeRGB(void) {
        rOut.period(0.001);  // set pwm period
        clearRGB();
    }
    
    void RGBStatusIndicator::setRGB(int r, int g, int b) {
        rOut = r;
        gOut = g;
        bOut = b;
    }
    
    void RGBStatusIndicator::clearRGB(void) {
        setRGB(255, 255, 255);
    }
    
    void RGBStatusIndicator::setStatus(Indication indication) {
        switch (indication) {
            case OK:
                setRGB(255, 0, 255);
                break;
            case FAIL:
                setRGB(0, 255, 255);
                break;
            case CLEAR:
                clearRGB();
                break;
        }
    }
}

