#include "Indication.h"
#include "PlcStatusIndicator.h"

namespace MachineVision {
    
    PlcStatusIndicator::PlcStatusIndicator(PinName out_pin)
        : output(out_pin) {
        setStatus(CLEAR);
    }
    
    void PlcStatusIndicator::setStatus(Indication indication) {
        switch (indication) {
            case OK:
                output = 1;
                break;
            case FAIL:
                output = 0;
                break;
            case CLEAR:
                output = 0;
        }
    }
}
