#ifndef CONFIGURATION_HEADER
#define CONFIGURATION_HEADER

#include <string>
#include "ConfigFile.h"

namespace MachineVision{
    
    class Configuration{
        
        public:
            bool use_dhcp;
            std::string ip;
            std::string netmask;
            std::string gateway;
            int tcp_port;
            
        public:
            bool useDhcp(void);
            std::string getIpAddress(void);
            std::string getNetmask(void);
            std::string getGateway(void);
            int getTcpPort(void);

        public:
            Configuration(void);
            bool readFromFile(LocalFileSystem * fs, char * configfile);
            bool writeConfiguration(LocalFileSystem * fs, char * configfile);
            
        private:
            bool readConfigParameter(ConfigFile * cfg, char * key, char * value, int buffer_size);
    };
}

#endif
