#ifndef TCP_DAEMON_HEADER
#define TCP_DAEMON_HEADER

#include "mbed.h"
#include "EthernetInterface.h"
#include "PlcStatusIndicator.h"

#define MAX_BACKLOG 1
#define TRIGGER_MSG "TRIGGER\r\n"

#define STR_FAIL "FAIL\r\n"
#define STR_OK "OK\r\n"
#define STR_CLEAR "CLEAR\r\n"

namespace MachineVision{
    
    class TcpDaemon{
        public:
            const static int BUFFER_SIZE = 512;
            const static int TCP_TIMEOUT = 250;
            const static int TCP_ACCEPT_TIMEOUT = 500;
            const static int MAX_READ_TIMEOUTS = 10;     // Maximum number of times to retry to read for rest of message
            
        private:
            int server_port;
            TCPSocketServer server;
            TCPSocketConnection client;

            char buffer[BUFFER_SIZE+1];
            bool keepListening;
            
            DigitalOut accept_led;
            DigitalOut receive_led;
            
            // Status Indicator
            StatusIndicator * status_indicator;

        public:
            /*
             * TcpDaemon constructor
             *
             * @server_port the port the daemon will be listening on
             */
            TcpDaemon(int server_port, PinName accept_led_pin, PinName receive_led_pin, StatusIndicator * indicator);

            /*
             * Make the daemon start listening for incoming connections
             */
            void startListening();

        private:
            /*
             * Bind to server socket
             *
             * @return true on success
             */
            bool bindSocket();

            /*
             * Listen for incoming connections
             */
            void doListen();
    };
}

#endif
