#ifndef RGB_STATUS_INDICATOR_HEADER
#define RGB_STATUS_INDICATOR_HEADER

#include "StatusIndicator.h"
#include "mbed.h"

namespace MachineVision{
    
    class RGBStatusIndicator: public StatusIndicator{
        public:

        private:
            PwmOut rOut;
            PwmOut gOut;
            PwmOut bOut;

        public:
            RGBStatusIndicator(PinName red_pin, PinName green_pin, PinName blue_pin);
            virtual void setStatus(Indication indication);  

        private:
            void initializeRGB(void);
            void setRGB(int r, int g, int b);
            void clearRGB(void);

    };
}

#endif
