#pragma once

#include <vector>
#include "continuous_task.h"
#include "periodic_task.h"

// Definition of template methods need to be inside header file.
// http://stackoverflow.com/questions/8752837/undefined-reference-to-template-class-constructor

namespace SimpleTaskScheduler {

  class TaskScheduler {

    private:
      std::vector<Task *> tasks;

    public:
      TaskScheduler(void);
      ~TaskScheduler(void);

    public:
      void update(void);
      void stop_task(unsigned int id);
      void start_task(unsigned int id);

    public:
      template<typename T> unsigned int create_continuous_task(T* object, void (T::*method)(void)) {
        Task * task = new ContinuousTask(object, method);
        return add_task(task);
      }

      template<typename T> unsigned int create_periodic_task(T* object, void (T::*method)(void), float period_seconds) {
        Task * task = new PeriodicTask(object, method, period_seconds);
        return add_task(task);
      }

    private:
      unsigned int add_task(Task * task);
  };

};
