#pragma once

#include "task.h"

// Definition of template methods need to be inside header file.
// http://stackoverflow.com/questions/8752837/undefined-reference-to-template-class-constructor

namespace SimpleTaskScheduler {

  class PeriodicTask : public Task {

    private:
      Ticker ticker;

    public:
      template<typename T> PeriodicTask(T* object, void (T::*method)(void), float period_seconds) : Task(object, method) {
        state = WAITING;
        nextState = WAITING;
        ticker.attach(this, &PeriodicTask::tick, period_seconds);
      }

    public:
      virtual void run(void);

    public:
      void tick(void);

  };
};
