#pragma once

#include "task.h"

// Definition of template methods need to be inside header file.
// http://stackoverflow.com/questions/8752837/undefined-reference-to-template-class-constructor

namespace SimpleTaskScheduler {

  class ContinuousTask : public Task {

    public:
      template<typename T> ContinuousTask(T* object, void (T::*method)(void)) : Task(object, method) {
        state = WAITING;
        nextState = SHOULD_RUN;
      }

    public:
      virtual void run(void);
      virtual void start(void);
  };
};
