#include "task_scheduler.h"

namespace SimpleTaskScheduler {

  TaskScheduler::TaskScheduler(void) { }

  TaskScheduler::~TaskScheduler(void) {
    for (unsigned int i = 0; i < tasks.size(); i++) {
      delete tasks[i];
    }
  }

  void TaskScheduler::update(void) {
    for (unsigned int i = 0; i < tasks.size(); i++) {
      tasks[i]->run();
    }
  }

  void TaskScheduler::stop_task(unsigned int id) {
    for (unsigned int i = 0; i < tasks.size(); i++) {
      if (tasks[i]->get_id() == id) {
        tasks[i]->stop();
      }
    }
  }

  void TaskScheduler::start_task(unsigned int id) {
    for (unsigned int i = 0; i < tasks.size(); i++) {
      if (tasks[i]->get_id() == id) {
        tasks[i]->start();
      }
    }
  }

  unsigned int TaskScheduler::add_task(Task * task) {
    tasks.push_back(task);
    return task->get_id();
  }
};
