#pragma once

#include "mbed.h"

// Definition of template methods need to be inside header file.
// http://stackoverflow.com/questions/8752837/undefined-reference-to-template-class-constructor

namespace SimpleTaskScheduler {

  enum TaskState { SHOULD_RUN, RUNNING, STOPPED, WAITING };

  class Task {

    public:
      unsigned int get_id(void);

    private:
      unsigned int id;

    private:
      Callback<void()> callback;

    protected:
      TaskState state;
      TaskState nextState;

    public:
      template<typename T> Task(T* object, void (T::*method)(void)) {
        this->callback.attach(object, method);
        id = generate_id();
        nextState = state = WAITING;    // Subclass should set correct state
      }

    public:
      virtual void run(void) = 0;
      virtual void stop(void);
      virtual void start(void);

    protected:
      void call(void);

    private:
      unsigned int generate_id(void);

  };
};
