#include "mbed.h"
#include "TRex.h"

DigitalOut aLED(LED1);      // Alive LED
Serial pc(USBTX, USBRX);    // TX, RX
I2CSlave slave(p28, p27);   // SDA, SCL

const int SLAVE_ADDRESS = 0x0E;
const int I2C_FREQUENCY = 100000;
const int I2C_BUFFER_SIZE = 30;

int main() {
    pc.baud(115200);
    
    // Alive LED
    int cAlive = 0;
    
    // Battery decrease counter
    int cBattery = 0;
    
    // Configure I2C
    slave.frequency(I2C_FREQUENCY);
    pc.printf("Slave is working @ %dHz\r\n", I2C_FREQUENCY);
    slave.address(SLAVE_ADDRESS);
    pc.printf("Slave is working @ SLAVE_ADDRESS = 0x%x\r\n", SLAVE_ADDRESS);

    // I2C buffer
    char buffer[I2C_BUFFER_SIZE];
    
    // Create TRex
    TRex trex;
    
    // Go infinite
    while (1) {
        int rec = slave.receive();
        switch (rec) {
            case I2CSlave::ReadAddressed:
                trex.getStatusDataPacket(buffer);
                if (!slave.write(buffer, TRex::SIZE_TREX_DATA_PACKET)) {
                    pc.printf("Send status to master success\r\n");
                } else {
                    pc.printf("Send status to master failed\r\n");
                }
                break;

            case I2CSlave::WriteAddressed:
                break;
        }

        // Clear buffer
        for (int i = 0; i < I2C_BUFFER_SIZE; i++) {
            buffer[i] = 0;   
        }
        
        // Alive LED
        cAlive = (cAlive + 1) % 100000;
        if (!cAlive) {
            aLED = !aLED;
        }
        
        // Battery decrease of TRex
        trex.determineBatteryVoltage();
    }
}
