#ifndef TREX_HEADER
#define TREX_HEADER

enum StatusDataPacketFields {
    STATUS_START = 0,
    STATUS_ERROR = 1,
    STATUS_BATTERY_MSB = 2,
    STATUS_BATTERY_LSB = 3,
    STATUS_LEFT_MOTOR_CURRENT_MSB = 4,
    STATUS_LEFT_MOTOR_CURRENT_LSB = 5,
    STATUS_LEFT_ENCODER_COUNT_MSB = 6,
    STATUS_LEFT_ENCODER_COUNT_LSB = 7,
    STATUS_RIGHT_MOTOR_CURRENT_MSB = 8,
    STATUS_RIGHT_MOTOR_CURRENT_LSB = 9,
    STATUS_RIGHT_ENCODER_COUNT_MSB = 10,
    STATUS_RIGHT_ENCODER_COUNT_LSB = 11,
    STATUS_ACCELEROMETER_X_MSB = 12,
    STATUS_ACCELEROMETER_X_LSB = 13,
    STATUS_ACCELEROMETER_Y_MSB = 14,
    STATUS_ACCELEROMETER_Y_LSB = 15,
    STATUS_ACCELEROMETER_Z_MSB = 16,
    STATUS_ACCELEROMETER_Z_LSB = 17,
    STATUS_IMPACT_X_MSB = 18,
    STATUS_IMPACT_X_LSB = 19,
    STATUS_IMPACT_Y_MSB = 20,
    STATUS_IMPACT_Y_LSB = 21,
    STATUS_IMPACT_Z_MSB = 22,
    STATUS_IMPACT_Z_LSB = 23
};

enum ErrorFlag {
    CLEAR = 0,
    START_BYTE = 1,
    PWM_FREQ = 2,
    SPEED = 4,
    SERVO = 8,
    IMPACT = 16,
    BATTERY = 32,
    I2C_ADDRESS = 64,
    I2C_SPEED = 128
};

class TRex {
    public:
        unsigned char startbyte;
        unsigned char errorflags;
        unsigned short batteryvoltage;
        unsigned short leftmotorcurrent;
        unsigned short rightmotorcurrent;
        unsigned short leftencodercount;
        unsigned short rightencodercount;
        unsigned short accelero_x;
        unsigned short accelero_y;
        unsigned short accelero_z;
        unsigned short impact_x;
        unsigned short impact_y;
        unsigned short impact_z;

        /* Number of bytes in the TREX byte array representation */
        const static int SIZE_TREX_DATA_PACKET = 24;
    public:
        /* Constructor */
        TRex();
        void getStatusDataPacket(char * buffer);
        void determineBatteryVoltage(void);
        
    private:
        void toBigEndianByteArray(char * bytes, unsigned short value);
};


#endif