#include "neopixel_string_factory.h"

NeoPixelString * NeoPixelStringFactory::createNeoPixelString(PinName spi_pin, unsigned int length) {
    // Create a temporary DigitalIn so we can configure the pull-down resistor.
    // (The mbed API doesn't provide any other way to do this.)
    // An alternative is to connect an external pull-down resistor.
    DigitalIn(spi_pin, PullDown);
    
    return new NeoPixelString(spi_pin, length);
}