#pragma once

#include "neopixel.h"
#include "colors.h"
 
class NeoPixelString : public neopixel::PixelArray {
    
    private:
        unsigned int length;
        neopixel::Pixel * pixels;

    public:
        NeoPixelString(PinName spi_pin, unsigned int length);
        unsigned int getLength(void);
        void update(void);
        void update(neopixel::Pixel singlecolor);
        void diagnose(void);
        neopixel::Pixel getPixel(unsigned int i);
        void setPixel(unsigned i, neopixel::Pixel pixel);
};