#include "effects_manager.h"

namespace Effects {
    
    EffectsManager::EffectsManager(void) {
        effect = 0;
    }
    
    void EffectsManager::registerEffect(Effect * effect) {
        this->effect = effect;
        effect->start();
    }
    
    void EffectsManager::execute(void) {
        if (effect) {
            effect->execute();
        }
    }
    
    void EffectsManager::unregisterEffect(void) {
        effect->stop();
        effect = 0;
    }

};