#include "effect.h"

namespace Effects {
    
    Effect::Effect(NeoPixelString * pixelstring, neopixel::Pixel color) {
        this->pixelstring = pixelstring;
        this->color = color;
        doExecute = false;
    }
    
    void Effect::start(void) {
        doExecute = false;
    }
    
    void Effect::stop(void) {
        doExecute = false;
    }
    
    NeoPixelString * Effect::getPixelString(void) {
        return this->pixelstring;
    }

    neopixel::Pixel Effect::getColor(void) {
        return color;
    }

    void Effect::requestExecute(void) {
        doExecute = true;
    }

    void Effect::clearExecute(void) {
        doExecute = false;
    }

    bool Effect::shouldExecute(void) {
        return doExecute;
    }

};