#pragma once

#include "neopixel_string.h"

namespace Effects {

    class Effect {
    
        private:
            NeoPixelString * pixelstring;
            neopixel::Pixel color;
            bool doExecute;
            
        public:
            Effect(NeoPixelString * pixelstring, neopixel::Pixel color);
    
        public:
            virtual void start(void);
            virtual void stop(void);
            NeoPixelString * getPixelString(void);
            neopixel::Pixel getColor(void);
            void requestExecute(void);
            void clearExecute(void);
            bool shouldExecute(void);
            virtual void execute(void) = 0;
    };
    
};