#include "neopixel_string.h"

NeoPixelString::NeoPixelString(PinName spi_pin, unsigned int length) : PixelArray(spi_pin) {
    this->length = length;
    pixels = new neopixel::Pixel[length];     // Actual buffer of colors
    
    // Clear all
    update(Colors::Black);
}

unsigned int NeoPixelString::getLength(void) {
    return this->length;
}

void NeoPixelString::update(void) {
    PixelArray::update(pixels, length);
}

void NeoPixelString::update(neopixel::Pixel singlecolor) {
    for (unsigned int i = 0; i < length; i++) {
        pixels[i] = singlecolor;
    }
    update();
}

neopixel::Pixel NeoPixelString::getPixel(unsigned int i) {
    if (i < this->length) {
        return pixels[i];
    }
}

void NeoPixelString::setPixel(unsigned i, neopixel::Pixel pixel) {
    if (i < this->length) {
        pixels[i] = pixel;
    }
}

void NeoPixelString::diagnose(void) {
    update(Colors::Black);
    wait(1);
    for (int i = 0; i < 5; i++) {
        update(ColorAdjuster::intensity(Colors::Red, 5));
        wait(0.5);
        update(ColorAdjuster::intensity(Colors::Green, 5));
        wait(0.5);
        update(ColorAdjuster::intensity(Colors::Blue, 5));
        wait(0.5);
    }
    
    update(Colors::Black);
    for (unsigned int i = 0; i < length; i++) {
        pixels[i] = ColorAdjuster::intensity(Colors::White, 5);
        PixelArray::update(pixels, length);
        wait(0.1);
    }
}