#include "strobe_effect.h"

namespace Effects {

    StrobeEffect::StrobeEffect(NeoPixelString * pixelstring, neopixel::Pixel initial_color, int delay_ms)
        : PeriodicEffect(pixelstring, initial_color, delay_ms) {
    
        current_state = OFF;
    }
    
    void StrobeEffect::execute(void) {
        if (shouldExecute()) {
            clearExecute();
            if (current_state == OFF) {
                getPixelString()->update(getColor());
                current_state = ON;
            } else {
                getPixelString()->update(Colors::Black);
                current_state = OFF;
            }
        }
    }

};