#include "shift_effect.h"
#include "colors.h"

namespace Effects {

    ShiftEffect::ShiftEffect(NeoPixelString * pixelstring, neopixel::Pixel color, int delay_ms, int groupsize)
        : PeriodicEffect(pixelstring, color, delay_ms) {
    
        this->groupsize = groupsize;
        state = FIRST_TIME;
    }
    
    void ShiftEffect::execute(void) {
        if (shouldExecute()) {
            clearExecute();
            if (state == FIRST_TIME) {
                for (unsigned i = 0; i < getPixelString()->getLength(); i++) {
                    if (i % groupsize == 0) {
                        getPixelString()->setPixel(i, getColor());
                    } else {
                        getPixelString()->setPixel(i, Colors::Black);
                    }
                }

                state = RUNNING;
            } else {

                unsigned int i = 0;
                neopixel::Pixel pix;
                neopixel::Pixel first;

                while (i < getPixelString()->getLength()) {
                    unsigned int group = i / groupsize;

                    if (i % groupsize == 0) {
                        first = getPixelString()->getPixel(i);
                    }

                    if (i == ((group+1)*groupsize)-1) { // last pix in group
                        getPixelString()->setPixel(i, first);
                    } else {
                        pix = getPixelString()->getPixel(i+1);
                        getPixelString()->setPixel(i, pix);
                    }

                    i++;
                }

            }
            getPixelString()->update();
        }
    }

};