#include "periodic_effect.h"

namespace Effects {
    
    PeriodicEffect::PeriodicEffect(NeoPixelString * pixelstring, neopixel::Pixel color, int delay_ms)
        : Effect(pixelstring, color) {

        this->delay_ms = delay_ms;
    }
    
    void PeriodicEffect::start(void) {
        Effect::start();
        ticker.attach(this, &PeriodicEffect::tick, delay_ms/1000.0);
    }
    
    void PeriodicEffect::stop(void) {
        Effect::stop();
        ticker.detach();
    }
    
    void PeriodicEffect::tick(void) {
        requestExecute();
    }

};