#pragma once

#include "LoggerInterface.h"
#include "mbed.h"

namespace LogItNow {

  class SerialLogger : public Log::LoggerInterface
  {
    public:
      SerialLogger(Serial* serial);
      void emergency(const char * message, ...);
      void alert(const char * message, ...);
      void critical(const char * message, ...);
      void error(const char * message, ...);
      void warning(const char * message, ...);
      void notice(const char * message, ...);
      void info(const char * message, ...);
      void debug(const char * message, ...);
      void log(Level level, const char * message, ...);

      void setLevel(Level level);

    protected:
      Serial* serial;
      Level level; // minimum level to log

    private:
      void log(Level level, const char * message, va_list args);
  };

};
