#include "serial_logger.h"
#include <stdarg.h>
#include <stdio.h>

namespace LogItNow {

  SerialLogger::SerialLogger(Serial* serial)
  {
      this->serial = serial;
  }

  void SerialLogger::emergency(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(EMERGENCY, message, args);
      va_end (args);
  }

  void SerialLogger::alert(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(ALERT, message, args);
      va_end (args);
  }

  void SerialLogger::critical(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(CRITICAL, message, args);
      va_end (args);
  }

  void SerialLogger::error(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(ERROR, message, args);
      va_end (args);
  }

  void SerialLogger::warning(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(WARNING, message, args);
      va_end (args);
  }

  void SerialLogger::notice(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(NOTICE, message, args);
      va_end (args);
  }

  void SerialLogger::info(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(INFO, message, args);
      va_end (args);
  }

  void SerialLogger::debug(const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(DEBUG, message, args);
      va_end (args);
  }

  void SerialLogger::log(Level level, const char * message, ...)
  {
      va_list args;
      va_start (args, message);
      log(level, message, args);
      va_end (args);
  }

  void SerialLogger::log(Level level, const char * message, va_list args)
  {
      if(level > this->level){
        return;
      }

      char levelString[16];
      switch(level)
      {
          case EMERGENCY:
              strcpy(levelString, "EMERGENCY");
              break;
          case ALERT:
              strcpy(levelString, "ALERT");
              break;
          case CRITICAL:
              strcpy(levelString, "CRITICAL");
              break;
          case ERROR:
              strcpy(levelString, "ERROR");
              break;
          case WARNING:
              strcpy(levelString, "WARNING");
              break;
          case NOTICE:
              strcpy(levelString, "NOTICE");
              break;
          case INFO:
              strcpy(levelString, "INFO");
              break;
          case DEBUG:
              strcpy(levelString, "DEBUG");
              break;
          default:
              strcpy(levelString, "DEBUG");
              break;
      }

      char buffer[256];
      vsprintf (buffer, message, args);
      serial->printf("%9s: %s\r\n", levelString, buffer);
  }

  void SerialLogger::setLevel(Level level)
  {
      this->level = level;
  }

};
