#pragma once

#include "LoggerInterface.h"

// NullLogger logs nothing but it allows us to inject other logger when necessary.
// With NullLogger we dont have to check if logger is set to actual logger.
// Kudos to Sandi Metz and her seminar on how to avoid if statements

// Source: http://stackoverflow.com/questions/1008019/c-singleton-design-pattern
namespace LogItNow {

  class NullLogger : public Log::LoggerInterface
  {
    public:
      static NullLogger * get_instance()
      {
        static NullLogger instance;   // Guaranteed to be destroyed.
                                      // Instantiated on first use.
        return &instance;
      }

    private:
        NullLogger() {}       // Constructor? (the {} brackets) are needed here.

        // C++ 03
        // ========
        // Dont forget to declare these two. You want to make sure they
        // are unacceptable otherwise you may accidentally get copies of
        // your singleton appearing.
        NullLogger(NullLogger const&);      // Don't Implement
        void operator=(NullLogger const&);  // Don't implement

        // C++ 11
        // =======
        // We can use the better technique of deleting the methods
        // we don't want.
    public:
        // NullLogger(NullLogger const&) = delete;
        // void operator=(NullLogger const&) = delete;

        // Note: Scott Meyers mentions in his Effective Modern
        //       C++ book, that deleted functions should generally
        //       be public as it results in better error messages
        //       due to the compilers behavior to check accessibility
        //       before deleted status

      public:
        void emergency(const char * message, ...) {};
        void alert(const char * message, ...) {};
        void critical(const char * message, ...) {};
        void error(const char * message, ...) {};
        void warning(const char * message, ...) {};
        void notice(const char * message, ...) {};
        void info(const char * message, ...) {};
        void debug(const char * message, ...) {};
        void log(Level level, const char * message, ...) {};
  };

};
