# Mbed LogItNow

Logger library that is build based on the LoggerInterface library that follows
the PSR-3 logger standard.

This library provides an abstract class logable to make your classes easily Logger
aware.

Besides that the LogItNow library also has a SerialLogger implementation and a NullLogger
for production applications where no logging should be done.

NullLogger is used as a default when making your classes Logger aware. It is implemented
using the Singleton pattern to avoid waste of resources.

## Using LogItNow

First make your class inherit from Logable as such

```C++
class Router : public LogItNow::Logable {
  //...
};
```

Now you can use the `set_logger()` method to inject a logger into the class
or you can provide it as an optional argument to your constructors as shown below:

```C++
  Router::Router(int address, Log::LoggerInterface * logger = 0) {
    set_logger(logger);
    logger->info("Setting up the router");
    //...
  }
```

## Dependencies

This library currently only depends on the LoggerInterface itself which can be found at
[https://developer.mbed.org/users/dwini/code/LoggerInterface/](https://developer.mbed.org/users/dwini/code/LoggerInterface/)
