#pragma once

#include "null_logger.h"

// Allow your classes to easily log by implementing Logable

namespace LogIt {

  class Logable
  {
    protected:
      Log::LoggerInterface * logger;

    public:
      Logable(void) {
        this->logger = NullLogger::get_instance();
      }

      void set_logger(Log::LoggerInterface * logger = 0) {
        if (logger == 0) {
          this->logger = NullLogger::get_instance();
        } else {
          this->logger = logger;
        }
      }
  };

};
