#include "mbed.h"

// Reference the MMA7660-Accelerometer library.
#include "MMA7660.h"

/*
    Variables definition:
        - LOOP_FOREVER  the infinity value.
        - ONE_SECOND_MILLISECOND one second in milliseconds
*/
#define LOOP_FOREVER 1
#define ONE_SECOND_MILLISECOND 1000

// Accelerometer object reference.
MMA7660 MMA(p28, p27);

// Led reference is show when Accelerometer is connected.
DigitalOut connectionLed(LED1);

/** 
*
* @file mbed_lab_2_Q_1.cpp
* @brief Using the MMA7660-Accelerometer library. 
* @details Write a program using the ‘MMA’ interface on the mbed application
* @details board to interface the on board accelerometer. 
* @details Print the X Y and Z every second.
* @author cdonovan
* @version 0.0.1
*
*/
int main()
{
    // Checks the MMA Connection 
    if (MMA.testConnection()) {
        // Enabled the Led
        connectionLed=1;
        
        // Start the Loop
        while(LOOP_FOREVER) {
            // Print out the Accelerometer readings
            printf("x:%lf y:%lf z:%lf\r\n",MMA.x(),MMA.y(),MMA.z());
            // Wait for a second
            wait_ms(ONE_SECOND_MILLISECOND);
        } // _END_OF_LOOP_
    }
} // _END_OF_MAIN_FUNCTION_