#pragma once

#include <mbed.h>
#include "es_wifi.h"

#define HTTP_200OK "200 OK\r\n"
#define HTTP_CL "Content-Length: "

class HTTPHelper
{
private:
    char m_io_buffer[ES_WIFI_PAYLOAD_SIZE];

public:

    HTTPHelper() {}
    ~HTTPHelper(){}


    bool HttpParseResponse(TCPConnector *net,uint8_t socket, char *content_buffer, uint32_t content_buffer_size, bool *status_ok, uint32_t *content_size)
    {
        uint16_t recv_bytes = 0;
        uint16_t http_content_len = 0;
        char *http_content_pivot = NULL;
        uint16_t content_chunk_size;
        bool res = false;

        *status_ok = false;
        *content_size = 0;

        // receive RESPONSE
        m_io_buffer[0] = 0;
        if(net->tcp_read(socket,m_io_buffer,ES_WIFI_PAYLOAD_SIZE,&recv_bytes,false))
        {
            if (recv_bytes > 0)
            {
                m_io_buffer[recv_bytes]=0;
                printf("%s\r\n",m_io_buffer);
                http_parse_response(m_io_buffer, recv_bytes, status_ok, &http_content_len);
                printf("> HTTP OK = %d Content len = %d\r\n", *status_ok, http_content_len);
                *content_size = http_content_len;

                /* fetch content */
                http_content_pivot = strstr(m_io_buffer, "\r\n\r\n");
                if (http_content_pivot != NULL)
                {
                    /* copy first content chunk */
                    http_content_pivot += 4;
                    content_chunk_size = strlen(http_content_pivot);
                    if (content_chunk_size < content_buffer_size) strcpy(content_buffer, http_content_pivot);
                    http_content_len -= content_chunk_size;
                    printf("http_content_len %d content_chunk_size %d\r\n",http_content_len,content_chunk_size);

                    /* continue to fetch content chunck */
                    while (http_content_len > 0)
                    {
                        printf("http_content_len %d\r\n",http_content_len);
                        if( net->tcp_read(socket,m_io_buffer,ES_WIFI_PAYLOAD_SIZE,&recv_bytes,true) == false ) break;
                        m_io_buffer[recv_bytes] = 0;
                        http_content_len -= recv_bytes;
                        if (recv_bytes == 0)
                        {
                            printf("> ERROR : http content len overflow\r\n");
                            break;
                        }
                        strcat(content_buffer,m_io_buffer);
                    }
                    res = (http_content_len == 0);
                }

            }
        }

        return res;

    }

private:

    void http_parse_response(char *http_chunk, uint16_t http_chunk_len, bool *status_code_ok, uint16_t *content_len)
    {
        char *line_pivot, *key_pivot;

        *status_code_ok = false;
        *content_len = 0;

        line_pivot = strstr(http_chunk, "\r\n");
        if (line_pivot == NULL)
            return ;

        key_pivot = strstr(http_chunk, HTTP_200OK);
        
        if (key_pivot != NULL)
            *status_code_ok = true;
        else
            *status_code_ok = false;

        *content_len = 0;
        while (1)
        {
            line_pivot = strstr(line_pivot + 2, "\r\n");
            if (line_pivot == NULL)
                break;
            key_pivot = strstr(http_chunk, HTTP_CL);
            if (key_pivot == NULL)
                continue;
            if (key_pivot < line_pivot)
            {
                key_pivot += strlen(HTTP_CL);
                *content_len = atoi((char const *)key_pivot);
                break;
            }
        }
    }


};