//#define DEBUG

#ifndef DEBUG
    #define DEVICE_SERIAL   0   //disable SERIAL so me can use P0_8 (shared with serial)
    #define DBG(...)
#else
    #define DBG printf
#endif

#include "mbed.h"
#include "BLE.h"
#include "GaragemService.h"
#include "SecurityService.h"
#include "ble/services/iBeacon.h"
#include "DeviceInformationService.h"

// HOW-TO TEST:
//create a string to write to the characteristic 2000:2001
//openssl enc -aes-128-cbc -K 9734062BA852A049CF5D40593B769014 -iv A2685636521871D02306E2EB8F7027B3 -out /dev/stdout -in inputfile
// TTTTIIIISSSSSSSS
// T -> 4 bytes Timestamp uint32_t
// I -> 4 bytes ID (chars)
// S -> 8 bytes SHARED_SECRET   (chars)

// Generating K and iv:
//openssl enc -aes-128-cbc -pass pass:********** -nosalt -P

#define SHARED_KEY  "figueiredo"
#define DEVICE_NAME    "Garagem"

BLE        ble;
DigitalOut actuatedLED(P0_19);
Timeout offRelay;
bool boot;
#ifndef DEBUG
DigitalOut relay(P0_8);
#endif

static const uint16_t uuid16_list[] = {GaragemService::GARAGEM_SERVICE_UUID, SecurityService::SECURITY_SERVICE_UUID};

GaragemService *garagemServicePtr;
SecurityService *securityServicePtr;

void switchOffRelay()
{
    actuatedLED = !actuatedLED;
    DBG("JA CHEGA...\r\n");
    #ifndef DEBUG
    relay = 0;
    #endif
}
    
void disconnectionCallback(Gap::Handle_t handle, Gap::DisconnectionReason_t reason)
{   
    ble.startAdvertising(); 
}

void onDataWrittenCallback(const GattWriteCallbackParams *params) {
    DBG("onDataWrittenCallback: handle = %d      len = %d\r\n", params->handle, params->len);
    garagemServicePtr->nextLastOpen(params->data, params->len);

    if ((params->handle == garagemServicePtr->getChallengeHandle()) && (params->len ==16)) {
        DBG("We have Challenge: data = %s\r\n", (char *) (params->data));
        
        uint8_t msg[16];
        securityServicePtr->decode(msg, (uint8_t *) params->data, 16);
        
        if(garagemServicePtr->checkMessage(msg) == GARAGEM_OK) {  
            DBG("ABRE-TE SESAMO!\r\n");

            #ifndef DEBUG
            relay = 1;
            #endif
            actuatedLED = !actuatedLED;
            //please cleanup afterwards
            offRelay.attach(&switchOffRelay, 1.0);
            
        } else {
            DBG("NO SUCH LUCK...\r\n");
        }
    } if(boot && (params->handle == securityServicePtr->getKeyHandle()) && (params->len > 0)) {
        securityServicePtr->setKey((char *) params->data);    
    }
    boot = false;
}

int main(void)
{
    DBG("Garagem v0\r\n");

    boot = true;
    actuatedLED  = true;
    #ifndef DEBUG
    relay = 0;
    #endif

    ble.init();
    
    // Note that the Garagem app that is in the Google Play store has the prefix for the BLE Nano hardcoded as F2:9B:4B, but newer Nanos do not have this prefix
    // The following line changes the address on your Nano to ensure it will work with the app as is.
    const uint8_t address1[] = {0x01,0x02,0x03,0x4B,0x9B,0xF2}; ble.setAddress(Gap::ADDR_TYPE_PUBLIC, address1);

    ble.onDisconnection(disconnectionCallback);
    ble.gattServer().onDataWritten(onDataWrittenCallback);

     /**
     * The Beacon payload has the following composition:
     * 128-Bit / 16byte UUID = E2 0A 39 F4 73 F5 4B C4 A1 2F 17 D1 AD 07 A9 61
     * Major/Minor  = 0x1122 / 0x3344
     * Tx Power     = 0xC8 = 200, 2's compliment is 256-200 = (-56dB)
     *
     * Note: please remember to calibrate your beacons TX Power for more accurate results.
     */
    const uint8_t uuid[] = {0xE2, 0x0A, 0x39, 0xF4, 0x73, 0xF5, 0x4B, 0xC4,
                            0xA1, 0x2F, 0x17, 0xD1, 0xAD, 0x07, 0xA9, 0x61};
    uint16_t majorNumber = 3800;
    uint16_t minorNumber = 1423;
    uint16_t txPower     = 0xBE;
    iBeacon ibeacon(ble, uuid, majorNumber, minorNumber, txPower);

    DeviceInformationService deviceInfo(ble, "diogogomes.com", DEVICE_NAME, "SN1", "hw-rev1", "fw-rev1", "soft-rev1");
    
    GaragemService garagemService(ble);
    garagemServicePtr = &garagemService;
    
    SecurityService securityService(ble);
    securityService.init(SHARED_KEY);
    securityServicePtr = &securityService;

    /* setup advertising */
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t *)uuid16_list, sizeof(uuid16_list));
    ble.gap().accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    ble.gap().setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    
    
    ble.gap().setAdvertisingInterval(1000); /* 1000ms. */
    ble.gap().startAdvertising();

    while (true) {
        ble.waitForEvent();
    }
}
