#ifndef __BLE_SECURITY_SERVICE_H__
#define __BLE_SECURITY_SERVICE_H__

#include "Crypto.h"
#include "Random.h"

class SecurityService {
public:
    const static uint16_t SECURITY_SERVICE_UUID              = 0x3000;
    const static uint16_t SECURITY_IV_CHARACTERISTIC_UUID = 0x3001;
    const static uint16_t SECURITY_KEY_CHARACTERISTIC_UUID = 0x3002;
    
    SecurityService(BLE &_ble) :
        ble(_ble), 
        SecurityIV(SECURITY_IV_CHARACTERISTIC_UUID, (uint8_t *) "IV"),
        SecurityKey(SECURITY_KEY_CHARACTERISTIC_UUID, (uint8_t *) "KEY")
    {
        GattCharacteristic *charTable[] = {&SecurityIV, &SecurityKey};
        
        GattService         SecurityService(SECURITY_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(SecurityService);
    }
    void init(char *shared_key) {
        //Initialize AES
        uint8_t new_iv[16] = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
        memcpy(iv, new_iv,16);
        ble.gattServer().write(SecurityIV.getValueHandle(), (uint8_t *)iv, 16*sizeof(uint8_t));    
        setKey(shared_key);
    }

    void decode(uint8_t *out, uint8_t *in, uint32_t len) {
        AES myAES(AES_128, myKey, iv);
        myAES.decrypt(out,in,len);
        genIV();
    }
    
    void setKey(char *shared_key) {
        DBG("Set shared_key = %s\r\n", shared_key);
        MD5::computeHash(myKey, (uint8_t*) shared_key, strlen(shared_key));
    } 

    void genIV() {
        Random rnd;
        rnd.init();
        rnd.getBytes(iv, 16);
        ble.gattServer().write(SecurityIV.getValueHandle(), (uint8_t *)iv, 16*sizeof(uint8_t));    
    }
    
    GattAttribute::Handle_t getKeyHandle() const {
        return SecurityKey.getValueHandle();
    }
    
private:
    uint8_t iv[16];
    uint8_t myKey[16];

    BLE   &ble;
    ReadOnlyArrayGattCharacteristic<uint8_t, 16> SecurityIV;
    WriteOnlyArrayGattCharacteristic<uint8_t, 16> SecurityKey;    
};

#endif /* #ifndef __BLE_SECURITY_SERVICE_H__ */
