#ifndef __BLE_GARAGEM_SERVICE_H__
#define __BLE_GARAGEM_SERVICE_H__
#include "History.h"

#define SHARED_SECRET   "ABRE-TE"

#define GARAGEM_OK                          0
#define GARAGEM_ERROR_REPETITION_ATTACK     1
#define GARAGEM_ERROR_WRONG_SHARED_SECRET   2

class GaragemService {
public:
    const static uint16_t GARAGEM_SERVICE_UUID              = 0x2000;
    const static uint16_t GARAGEM_CHALLENGE_CHARACTERISTIC_UUID = 0x2001;
    const static uint16_t GARAGEM_LAST_OPEN_TS_UUID = 0x2002;
    const static uint16_t GARAGEM_LAST_OPEN_ID_UUID = 0x2003;

    GaragemService(BLE &_ble) :
        ble(_ble), 
        GaragemChallenge(GARAGEM_CHALLENGE_CHARACTERISTIC_UUID, (uint8_t *)"INIT"),
        GaragemLastOpenTS(GARAGEM_LAST_OPEN_TS_UUID, 0, GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY),
        GaragemLastOpenID(GARAGEM_LAST_OPEN_ID_UUID, (uint8_t *)"INIT", GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY)
    {
        GattCharacteristic *charTable[] = {&GaragemChallenge, &GaragemLastOpenTS, &GaragemLastOpenID};
        GattService         GaragemService(GARAGEM_SERVICE_UUID, charTable, sizeof(charTable) / sizeof(GattCharacteristic *));
        ble.gattServer().addService(GaragemService);
    }

    GattAttribute::Handle_t getChallengeHandle() const {
        return GaragemChallenge.getValueHandle();
    }
    GattAttribute::Handle_t getLastOpenTSHandle() const {
        return GaragemLastOpenTS.getValueHandle();
    }
    void nextLastOpen(const uint8_t *data, uint16_t len) {
        uint64_t token = history.getToken();
        uint8_t *tok = (uint8_t *) &token;
        DBG("LAST:\tTS=%lu\tID=%c%c%c%c\r\n", *((uint32_t *) tok), tok[4], tok[5], tok[6], tok[7]); 
        ble.gattServer().write(GaragemLastOpenTS.getValueHandle(), (uint8_t *)&tok[0], 4*sizeof(uint8_t));
        ble.gattServer().write(GaragemLastOpenID.getValueHandle(), (uint8_t *)&tok[4], 4*sizeof(uint8_t));

    }

    int checkMessage(uint8_t *msg) {
        DBG("WHAT ? %s\r\n", (char *) msg);

        uint64_t token;
        memcpy(&token, msg, 8);

        DBG("TS=%lu\tID=%c%c%c%c\tSYSKEY=%s\r\n", *((uint32_t *) msg), msg[4], msg[5], msg[6], msg[7], &msg[8]); 

        //check we are not a victim of a repetition attack
        DBG("%lu\t>=\t%lu\r\n", history.last_ts(), *((uint32_t*) &msg[0]));
        if(history.last_ts() >= *((uint32_t *) &msg[0])) {
            DBG("HA HA repetition here...\r\n");
            return GARAGEM_ERROR_REPETITION_ATTACK;
        }
        
        if (strncmp((const char *) &msg[8],SHARED_SECRET,7)==0) {//TODO MOVE TO 8 CHARS
            //Save our success
            history.save(token);
            ble.gattServer().write(GaragemLastOpenTS.getValueHandle(), (const uint8_t *)&msg[0], 4*sizeof(uint8_t));
            ble.gattServer().write(GaragemLastOpenID.getValueHandle(), (const uint8_t *)&msg[4], 4*sizeof(uint8_t));
        
            return GARAGEM_OK;
        } else {
            return GARAGEM_ERROR_WRONG_SHARED_SECRET;
        }
    }
    
private:
    BLE   &ble;
    WriteOnlyArrayGattCharacteristic<uint8_t, 16>  GaragemChallenge;
    ReadOnlyGattCharacteristic<uint32_t> GaragemLastOpenTS;
    ReadOnlyArrayGattCharacteristic<uint8_t, 4> GaragemLastOpenID;
    
    History<16> history;
};

#endif /* #ifndef __BLE_GARAGEM_SERVICE_H__ */
