#include "StepperMotor.h"

/* TODO:
_RunDegrees(float degrees)
_SetDegreeJump(float degree)
_DegreeUp()
_DegreeDown()
*/
Serial debug(USBTX,USBRX);

StepperMotorDrv::StepperMotorDrv(PinName PinDir, PinName PinClk):Dir(PinDir),Clock(PinClk)
{
    MaxSpeed=100;       // default 100 Hz
    Speed=50;           // default 50 Hz
    SpeedJump=1;        // default 1 Hz
    DutyCycle=50;       // default 50 %
    SetDir(CW);         // default ClockWise
    Clock=0;            // Set to 0 for sure
    CurrPos=0;          // Set 0 when power on
    CurrDegree=0;       // default 0 degrees
    DegreesPerStep=0;   // 0 -> NOT SET
}

StepperMotorDrv::~StepperMotorDrv()
{
}

// Set duty cycle of pwm in percentual
void StepperMotorDrv::SetDutyCyclePerc(float PercentualValue)
{
    if (PercentualValue > 100) PercentualValue=100;
    DutyCycle=PercentualValue;
    tUp=(tPeriod/100)*DutyCycle;
    tDown=tPeriod-tUp;
}

// Set duty cycle of pwm as float value from 0.0 to 1.0
// Values grater than 1.0 were used as 0.n
void StepperMotorDrv::SetDutyCycle(float DecimalValue)
{
    if (DecimalValue > 1){
        DecimalValue=DecimalValue - int(DecimalValue);
    }    
    DutyCycle=DecimalValue*100;
    tUp=tPeriod*DecimalValue;
    tDown=tPeriod-tUp;
}

// Set Raw Speed in Hz
void StepperMotorDrv::SetSpeed(float SpeedHz)
{
    Speed=SpeedHz;
    tPeriod=1/Speed;
    // Recalculate also DutyCycle t for new period
    tUp=tPeriod*(DutyCycle/100);
    tDown=tPeriod-tUp;
}

void StepperMotorDrv::SetMaxSpeed(float MaxSpeedHz)
{
    MaxSpeed=MaxSpeedHz;
}

void StepperMotorDrv::SetSpeedPerc(float PercValue)
{
    Speed=(MaxSpeed/100)*PercValue;
    tPeriod=1/Speed;
    // Recalculate also DutyCycle t for new period
    tUp=tPeriod*(DutyCycle/100);
    tDown=tPeriod-tUp;
}

float StepperMotorDrv::SpeedUp(float ValueHz)
{
    Speed+=ValueHz;
    // Recalculate also DutyCycle t for new period
    tUp=tPeriod*(DutyCycle/100);
    tDown=tPeriod-tUp;
    
    return(Speed);
}

float StepperMotorDrv::SpeedDown(float ValueHz)
{
    Speed-=ValueHz;
    // Recalculate also DutyCycle t for new period
    tUp=tPeriod*(DutyCycle/100);
    tDown=tPeriod-tUp;
    
    return Speed;
}

void StepperMotorDrv::SetSpeedJump(float ValueHz)
{
    SpeedJump=ValueHz;
}

float StepperMotorDrv::SpeedUp(void)
{
    return(SpeedUp(SpeedJump));
}

// Decrement Speed by <Step> Value
// Return: new Speed in Hz
float StepperMotorDrv::SpeedDown(void)
{
    return(SpeedDown(SpeedJump));
}

// Get the current speed in Hz
float StepperMotorDrv::GetSpeed(void)
{
    return Speed;
}

// Get the current speed in Perc Value
float StepperMotorDrv::GetSpeedPerc(void)
{
    return (Speed*100)/MaxSpeed;
}

// Get the current MAX Speed in Hz
float StepperMotorDrv::GetMaxSpeed(void)
{
    return (MaxSpeed);
}

// Get the current Duty Cycle in Perc Value
float StepperMotorDrv::GetDutyCyclePerc(void)
{
    return (DutyCycle);
}

// Get the current Duty Cycle decimal value
float StepperMotorDrv::GetDutyCycle(void)
{
    return (DutyCycle/100);
}

// Get the current Step Value
float StepperMotorDrv::GetSpeedJump(void)
{
    return (SpeedJump);
}

// Set Rotation Direction: CW=1 CC=0
void StepperMotorDrv::SetDir(bool RotationDir)
{
    Dir=RotationDir;
}

// Set Rotation Direction CW
void StepperMotorDrv::SetDirCW(void)
{
    Dir=CW;
}

// Set Rotation Direction CC
void StepperMotorDrv::SetDirCC(void)
{
    Dir=CC;
}

// Set Rotation Direction CW
void StepperMotorDrv::RevertDir(void)
{
    Dir=!Dir;
}

// Get Rotation Direction Direction
// Return: CW=1 or CC=0
bool StepperMotorDrv::GetDir(void)
{
    return(Dir);
}

void StepperMotorDrv::Run(void)
{
    Clock.period(tPeriod);
    Clock.write(DutyCycle/100);   
}

// Stop the Motor
void StepperMotorDrv::Stop(void)
{
    Clock=0;
}

void StepperMotorDrv::RunStep(int nrSteps, bool RotationDir)
{
    Dir=RotationDir;
    int StepAdd=(0-1)+(RotationDir*2);
    float DegreeAdd=DegreesPerStep*(float(StepAdd));
    
    for (int step=0; step<nrSteps; step++){
        Clock=1;
        wait(tUp);
        Clock=0;
        wait(tDown);
        CurrPos=CurrPos+StepAdd;       // Update Current Step Position
        CurrDegree=CurrDegree+DegreeAdd;  // Update Current Degree Position
        //debug.printf("Current Pos: %d Degree: %f\r\n",CurrPos,CurrDegree);
    }    
}

void StepperMotorDrv::RunStep(int nrSteps)
{
    RunStep(nrSteps,Dir);
}

void StepperMotorDrv::RunStep(void)
{
    RunStep(1,Dir);
}

void StepperMotorDrv::RunStepCW(void)
{
    RunStep(1,CW);
}

void StepperMotorDrv::RunStepCC(void)
{
    RunStep(1,CC);
}

void StepperMotorDrv::SetZero(void)
{
    CurrPos=0;
    CurrDegree=0;
}

void StepperMotorDrv::SetCurrPos(int Pos)
{
    CurrPos=Pos;
}

int StepperMotorDrv::GetCurrPos(void)
{
    return(CurrPos);
}

float StepperMotorDrv::GetPeriod(void)
{
    return(tPeriod);
}

void StepperMotorDrv::SetDegreePerStep(float Degrees){
    DegreesPerStep=Degrees;
}

float StepperMotorDrv::GetDegreePerStep(void){
    return(DegreesPerStep);
}

float StepperMotorDrv::GetCurrDegree(void){
    return(CurrDegree);
}
   
    