#include "mbed.h"
#include "Servo.h"

void ShowMenu(void);

Servo myservo(p22);
Serial pc(USBTX, USBRX);

int main() {
       
    ShowMenu();
    
    float pulsemin = myservo.ReadPulseMin();
    float pulsemax = myservo.ReadPulseMax();
    float degreesmin = myservo.ReadDegreesMin();
    float degreesmax = myservo.ReadDegreesMax();
    
    while(1) {                   
        float degrees=myservo.ReadDegrees();
        float position=myservo.Read();
        printf("read position = %f, read degrees = %f\r\n", position, degrees);
        
        switch(pc.getc()) {
            case ' ': ShowMenu(); break;
            case 'z':
                printf("pulsemin = %f, degreesmin = %f, pulsemax = %f degreesmax = %f\r\n", pulsemin, degreesmin, pulsemax, degreesmax);
                break;
            case '1': myservo = 0.0; break;
            case '2': myservo = 0.5; break;
            case '3': myservo = 1.0; break;
            case 'q':
                pulsemin += 0.0001; myservo.DefinePulseMin(pulsemin,degreesmin); myservo = 0.0;
                printf("+pulsemin = %f, degreesmin = %f", pulsemin, degreesmin);
                break;
            case 'a':
                pulsemin -= 0.0001; myservo.DefinePulseMin(pulsemin,degreesmin); myservo = 0.0;
                printf("-pulsemin = %f, degreesmin = %f", pulsemin, degreesmin);
                break;
            case 'w':
                pulsemax += 0.0001; myservo.DefinePulseMax(pulsemax,degreesmax); myservo = 1.0;
                printf("+pulsemax = %f, degreesmax = %f", pulsemax, degreesmax);
                break;
            case 's':
                pulsemax -= 0.0001; myservo.DefinePulseMax(pulsemax,degreesmax); myservo = 1.0;
                printf("-pulsemax = %f, degreesmax = %f", pulsemax, degreesmax);
                break;
            case 'e':
                degreesmin += 1; myservo.DefinePulseMin(pulsemin,degreesmin); myservo = 0.0;
                printf("pulsemin = %f, +degreesmin = %f", pulsemin, degreesmin);
                break;
            case 'd':
                degreesmin -= 1; myservo.DefinePulseMin(pulsemin,degreesmin); myservo = 0.0;
                printf("pulsemin = %f, -degreesmin = %f", pulsemin, degreesmin);
                break;
            case 'r':
                degreesmax += 1; myservo.DefinePulseMax(pulsemax,degreesmax); myservo = 1.0;
                printf("pulsemax = %f, +degreesmax = %f", pulsemax, degreesmax);
                break;
            case 'f':
                degreesmax -= 1; myservo.DefinePulseMax(pulsemax,degreesmax); myservo = 1.0;
                printf("pulsemax = %f, -degreesmax = %f", pulsemax, degreesmax);
                break;
            case '6': degrees += 5.0; myservo.WriteDegrees(degrees); break;
            case '4': degrees -= 5.0; myservo.WriteDegrees(degrees); break;
            case '5': degrees = 0.0; myservo.WriteDegrees(degrees); break;
        }
        
    }
}

void ShowMenu(void)
{
    printf("Servo Test and calibration:\r\n");
    printf("1,2,3 - Position Servo (full left, middle, full right)\r\n");
    
    printf("q,a - Decrease or Increase pulsemin using pulse value\r\n");
    printf("w,s - Decrease or Increase pulsemax using pluse value\r\n");
    printf("e,d - Decrease or Increase pulsemin using degree value\r\n");
    printf("r,f - Decrease or Increase pulsemax using degree value\r\n");
    
    printf("6,4 - Degrees +5 -5\r\n");
    printf("5 - Degrees = 0.0 \r\n");
    printf("SPACE - Show this menu\r\n");
    printf("z - Print Servo Values\r\n");
    printf("\r\nInstructions:\r\n");
    printf("Decrease pulsemin until the servo reach the full left position\r\n"
           "Decrease degreesmin until the value reach the correct degrees you see\r\n"
           "Increase pulsemin until the servo reach the full right position\r\n"
           "Increase degreesmin until the value reach the correct degrees you see\r\n");
}