#ifndef SRF02_H
#define SRF02_H

#include "mbed.h"


/** Library to control SRF02 ultrasonic sensor */
class SRF02
{
 public:
    /** Creates an instance of the class
    *
    * @param sda I2C sda Pin
    * @param scl I2C scl Pin
    */
    SRF02(PinName sda, PinName scl, int addr);
  
    /** Destroys instance */
    ~SRF02();
  
    /** Read the range data in centimeters */
    int readcm();     

    /** Read the range data in inches */
    int readinch();
  
    /** Change the adress of the device. This is very usefull when there are more sensors.
    * This function must be executed with only one sensor conected.
    */
    void change_addr(char new_addr);
  
 private:
    /** wait for ranging to complete
    * This function is for internal use
    */
    void wait_ranging(void);                                        
    I2C m_i2c;
    int m_addr;

};

#endif