#include "SRF02.h"

SRF02::SRF02(PinName sda, PinName scl, int addr) : m_i2c(sda, scl), m_addr(addr)
{
}

SRF02::~SRF02()
{
}

//Get the data in centimeters
int SRF02::readcm()
{
 char cmd[2];
 char eco_high[1],eco_low[1]; //this is because the sensor, sends the data in tow bytes, and  you have tu read from two different registers 0x02 and 0x03;


    // Get range data from SRF02 in centimeters
    cmd[0] = 0x00;                      
    cmd[1] = 0x51;                     
    m_i2c.write(m_addr, cmd, 2);          

    wait_ranging();


    cmd[0] = 0x02;                        
    m_i2c.write(m_addr, cmd, 1, 1);        
    m_i2c.read(m_addr, eco_high, 1);            
    
    cmd[0] = 0x03;
    m_i2c.write(m_addr,cmd,1,1);
    m_i2c.read(m_addr,eco_low,1);

    int range = (eco_high[0]<<8)|eco_low[0];

    return range;
}

//Get the data in inches
int SRF02::readinch()
{
 char cmd[2];
 char eco_high[1],eco_low[1]; //this is because the sensor, sends the data in tow bytes, and  you have tu read from two different registers 0x02 and 0x03;

    cmd[0] = 0x00;                      
    cmd[1] = 0x50;                     
    m_i2c.write(m_addr, cmd, 2);          

    wait_ranging();
    
    cmd[0] = 0x02;                        
    m_i2c.write(m_addr, cmd, 1, 1);        
    m_i2c.read(m_addr, eco_high, 1);            
    
    cmd[0] = 0x03;
    m_i2c.write(m_addr,cmd,1,1);
    m_i2c.read(m_addr,eco_low,1);

    int range = (eco_high[0]<<8)|eco_low[0];

    return range;
}

//Change adress of the device. Remember to have only one sensor conected to execute this method.
void SRF02::change_addr(char new_addr)
{
 char cmd[2];
    
    cmd[0]=0x00;
    cmd[1]=0xA0;
    m_i2c.write(m_addr,cmd,2);
    cmd[0]=0x00;
    cmd[1]=0xAA;
    m_i2c.write(m_addr,cmd,2);
    cmd[0]=0x00;
    cmd[1]=0xA5;
    m_i2c.write(m_addr,cmd,2);
    cmd[0]=0x00;
    cmd[1]=new_addr;
    m_i2c.write(m_addr,cmd,2);
    
    }
    
void SRF02::wait_ranging(void)
{
 char eco;
 
    do {
        eco=m_i2c.read(1);
    }while(eco == 0xff);    
}    
    