#include "mbed.h"
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "FXOS8700Q.h"
#include "Bandpass.h"
#include "time.h"
#include <stdint.h>
  
typedef float  float32_t;

float w[NUM_SECTIONS][2]={0};
//float wY[NUM_SECTIONSY][2]={0};

//**********Serial Communication for Terminal**************

Serial pc(USBTX,USBRX);
I2C i2c(PTE25, PTE24);

FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);

int accelerometer()
{ 
    {   int section,si;
        float32_t inputX, inputY;
        float32_t wnX,ynX,filtered_opX, wnY,ynY, filtered_opY;
        float32_t energyX,energyY;
        float32_t avgenrX=0.0, avgenrY=0.0, avgenrMag;
   
//*******************Accelerometer reading**********************   
        motion_data_units_t acc_data, mag_data;
        motion_data_counts_t acc_raw, mag_raw;
        float32_t faX, faY, faZ, fmX, fmY, fmZ, tmp_float32_t32_t32_t32_t32_t;
        int16_t raX, raY, raZ, rmX, rmY, rmZ, tmp_int;
        int16_t accX,accY,accZ;
        acc.enable();
        mag.enable();
        acc.getAxis(acc_raw);
        mag.getAxis(mag_raw);
        acc.getX(raX);
        acc.getY(raY);
        acc.getZ(raZ);
        mag.getX(rmX);
        mag.getY(rmY);
        mag.getZ(rmZ);
        acc.getAxis(acc_data);
        mag.getAxis(mag_data);
        acc.getX(faX);
        acc.getY(faY);
        acc.getZ(faZ);
        mag.getX(fmX);
        mag.getY(fmY);
        mag.getZ(fmZ);
        puts("");
        //}
        inputX=(float32_t)(faX);
        
//--------------X---------------Filter (Band Pass)-------------------X-----------------------x---------------
      for (si=0;si<100;si++)
      
        for (section=0;section<NUM_SECTIONS;section++)
        {
            wnX=inputX-a[section][1]*w[section][0]-a[section][2]*w[section][1]; // Filter for Input X
            ynX=b[section][0]*wnX+b[section][1]*w[section][0]+b[section][2]*w[section][1];
            w[section][1]=w[section][0];
            w[section][0]=wnX;
            inputX=ynX;
        }
        
        filtered_opX=(float32_t)(ynX);
       
        
        
//------------X---------------Energy Computation------------X---------------------------
        energyX=abs(filtered_opX)*abs(filtered_opX); 
        avgenrX=avgenrX+energyX; 
        printf(" FilteredX = %1.4ff\t , UnfilteredX = %1.4ff\t EnergyX = %1.4ff\n ",filtered_opX,faX,avgenrX);
    
        if (avgenrX*100>15)
       {printf(" Knock Detected Retard Ignition angle x = 100 ");}
       else
       {}}
}
int main(void)
{   while(true)
    accelerometer();
    
}
