#ifndef GLCD_H
#define GLCD_H
//------------includes-----------------
#include "mbed.h"
//------------
/**
* Graphic LCD 128x64 Library
*
* Example:
* @code
* 
* @endcode
*/
//------------defines------------------
#define BLACK   1
#define WHITE   0
#define OPAC    0
#define TRANS   1
#define FILL    1
#define NOFILL  0
#define LEFT    0
#define RIGHT   1
#define DASH    0xFF // All pixel set on line
#define DASHOFF 0x00
#define BIT_SET(x,n) (x=x | (0x01<<n))
#define BIT_TEST(x,n) (x & (0x01<<n))
#define BIT_CLEAR(x,n) (x=x & ~(0x01<<n))
#define PI 3.14159265
// -----------font---------------------
// Font 3x5
static char FONT_3x5[] = {
// @Font start 3x5
    3, // witdh
    5, // height
    ' ', // First char
    '>', // Last char
    0x00, 0x00, 0x00, // Space
    0x00, 0x17, 0x00, // !
    0x07, 0x00, 0x03, // "
    0x0A, 0x1F, 0x0A, // #
    0x12, 0x17, 0x12, // +/-   old  $
    0x03, 0x1B, 0x18, // %
    0xFF, 0x05, 0x07, // _||_   Pulse
    0x00, 0x03, 0x00, // '
    0x1F, 0x15, 0x11, // (  // E ete
    0x1F, 0x04, 0x1F, // )  // H hivers
    0x0A, 0x04, 0x0A, // *
    0x04, 0x0E, 0x04, // +
    0x00, 0x10, 0x00, // ,
    0x04, 0x04, 0x04, // -
    0x00, 0x08, 0x00, // .
    0x08, 0x04, 0x02, // /
    0x0F, 0x11, 0x1E, // 0
    0x12, 0x1F, 0x10, // 1
    0x0D, 0x15, 0x16, // 2
    0x11, 0x15, 0x0E, // 3
    0x07, 0x04, 0x1E, // 4
    0x17, 0x15, 0x09, // 5
    0x0F, 0x15, 0x18, // 6
    0x01, 0x1D, 0x03, // 7
    0x0F, 0x15, 0x1E, // 8
    0x07, 0x15, 0x1E, // 9
    0x00, 0x0A, 0x00, // :
    0x10, 0x08, 0x00, // ;
    0x04, 0x0A, 0x11, // <
    0x0A, 0x0A, 0x0A, // =
    0x11, 0x0A, 0x04, // >
    // @Font end 3x5
};

// Font 5x7
static char FONT_5x7[] = {
// @Font start 5x7
    5, // witdh
    7, // height
    ' ', // First char
    '~', // Last char
    0x00, 0x00, 0x00, 0x00, 0x00, // SPACE
    0x00, 0x00, 0x5F, 0x00, 0x00, // !
    0x00, 0x03, 0x00, 0x03, 0x00, // "
    0x14, 0x3E, 0x14, 0x3E, 0x14, // #
    0x00, 0x22, 0x27, 0x22, 0x00, // now +/- before 0x24, 0x2A, 0x7F, 0x2A, 0x12, // $
    0x43, 0x33, 0x08, 0x66, 0x61, // %
    0x40, 0x7F, 0x02, 0x7F, 0x40, // Now _||_ before 0x36, 0x49, 0x55, 0x22, 0x50, // &
    0x00, 0x05, 0x03, 0x00, 0x00, // '
    0x00, 0x1C, 0x22, 0x41, 0x00, // (
    0x00, 0x41, 0x22, 0x1C, 0x00, // )
    0x14, 0x08, 0x3E, 0x08, 0x14, // *
    0x08, 0x08, 0x3E, 0x08, 0x08, // +
    0x00, 0x50, 0x30, 0x00, 0x00, // ,
    0x08, 0x08, 0x08, 0x08, 0x08, // -
    0x00, 0x60, 0x60, 0x00, 0x00, // .
    0x20, 0x10, 0x08, 0x04, 0x02, // /
    0x3E, 0x51, 0x49, 0x45, 0x3E, // 0
    0x04, 0x02, 0x7F, 0x00, 0x00, // 1
    0x42, 0x61, 0x51, 0x49, 0x46, // 2
    0x22, 0x41, 0x49, 0x49, 0x36, // 3
    0x18, 0x14, 0x12, 0x7F, 0x10, // 4
    0x27, 0x45, 0x45, 0x45, 0x39, // 5
    0x3E, 0x49, 0x49, 0x49, 0x32, // 6
    0x01, 0x01, 0x71, 0x09, 0x07, // 7
    0x36, 0x49, 0x49, 0x49, 0x36, // 8
    0x26, 0x49, 0x49, 0x49, 0x3E, // 9
    0x00, 0x36, 0x36, 0x00, 0x00, // :
    0x00, 0x56, 0x36, 0x00, 0x00, // ;
    0x08, 0x14, 0x22, 0x41, 0x00, // <
    0x14, 0x14, 0x14, 0x14, 0x14, // =
    0x00, 0x41, 0x22, 0x14, 0x08, // >
    0x02, 0x01, 0x51, 0x09, 0x06, // ?
    0x3E, 0x41, 0x59, 0x55, 0x5E, // @
    0x7E, 0x09, 0x09, 0x09, 0x7E, // A
    0x7F, 0x49, 0x49, 0x49, 0x36, // B
    0x3E, 0x41, 0x41, 0x41, 0x22, // C
    0x7F, 0x41, 0x41, 0x41, 0x3E, // D
    0x7F, 0x49, 0x49, 0x49, 0x41, // E
    0x7F, 0x09, 0x09, 0x09, 0x01, // F
    0x3E, 0x41, 0x41, 0x49, 0x3A, // G
    0x7F, 0x08, 0x08, 0x08, 0x7F, // H
    0x00, 0x41, 0x7F, 0x41, 0x00, // I
    0x30, 0x40, 0x40, 0x40, 0x3F, // J
    0x7F, 0x08, 0x14, 0x22, 0x41, // K
    0x7F, 0x40, 0x40, 0x40, 0x40, // L
    0x7F, 0x02, 0x0C, 0x02, 0x7F, // M
    0x7F, 0x02, 0x04, 0x08, 0x7F, // N
    0x3E, 0x41, 0x41, 0x41, 0x3E, // O
    0x7F, 0x09, 0x09, 0x09, 0x06, // P
    0x1E, 0x21, 0x21, 0x21, 0x5E, // Q
    0x7F, 0x09, 0x09, 0x09, 0x76, // R
    0x26, 0x49, 0x49, 0x49, 0x32, // S
    0x01, 0x01, 0x7F, 0x01, 0x01, // T
    0x3F, 0x40, 0x40, 0x40, 0x3F, // U
    0x1F, 0x20, 0x40, 0x20, 0x1F, // V
    0x7F, 0x20, 0x10, 0x20, 0x7F, // W
    0x41, 0x22, 0x1C, 0x22, 0x41, // X
    0x07, 0x08, 0x70, 0x08, 0x07, // Y
    0x61, 0x51, 0x49, 0x45, 0x43, // Z
    0x00, 0x7F, 0x41, 0x00, 0x00, // [
    0x02, 0x04, 0x08, 0x10, 0x20, // "\"
    0x00, 0x00, 0x41, 0x7F, 0x00, // ]
    0x04, 0x02, 0x01, 0x02, 0x04, // ^
    0x40, 0x40, 0x40, 0x40, 0x40, // _
    0x01, 0x3E, 0x41, 0x41, 0x22, // ` now &#65533;C Before  0x00, 0x01, 0x02, 0x04, 0x00,
    0x20, 0x54, 0x54, 0x54, 0x78, // a
    0x7F, 0x44, 0x44, 0x44, 0x38, // b
    0x38, 0x44, 0x44, 0x44, 0x44, // c
    0x38, 0x44, 0x44, 0x44, 0x7F, // d
    0x38, 0x54, 0x54, 0x54, 0x18, // e
    0x04, 0x04, 0x7E, 0x05, 0x05, // f
    0x08, 0x54, 0x54, 0x54, 0x3C, // g
    0x7F, 0x08, 0x04, 0x04, 0x78, // h
    0x00, 0x44, 0x7D, 0x40, 0x00, // i
    0x20, 0x40, 0x44, 0x3D, 0x00, // j
    0x7F, 0x10, 0x28, 0x44, 0x00, // k
    0x00, 0x41, 0x7F, 0x40, 0x00, // l
    0x7C, 0x04, 0x78, 0x04, 0x78, // m
    0x7C, 0x08, 0x04, 0x04, 0x78, // n
    0x38, 0x44, 0x44, 0x44, 0x38, // o
    0x7C, 0x14, 0x14, 0x14, 0x08, // p
    0x08, 0x14, 0x14, 0x14, 0x7C, // q
    0x00, 0x7C, 0x08, 0x04, 0x04, // r
    0x48, 0x54, 0x54, 0x54, 0x20, // s
    0x04, 0x04, 0x3F, 0x44, 0x44, // t
    0x3C, 0x40, 0x40, 0x20, 0x7C, // u
    0x1C, 0x20, 0x40, 0x20, 0x1C, // v
    0x3C, 0x40, 0x30, 0x40, 0x3C, // w
    0x44, 0x28, 0x10, 0x28, 0x44, // x
    0x0C, 0x50, 0x50, 0x50, 0x3C, // y
    0x44, 0x64, 0x54, 0x4C, 0x44, // z
    0x00, 0x08, 0x36, 0x41, 0x41, // {
    0x00, 0x00, 0x7F, 0x00, 0x00, // |
    0x41, 0x41, 0x36, 0x08, 0x00, // }
    0x02, 0x01, 0x02, 0x04, 0x02, // ~
    // @Font end 5x7 suite
};

static char ICON_Question[] = {
    5,
    8,
    0x0e,0x11,0x11,0x08,0x04,0x04,0x00,0x04
};
//------------class--------------------
class GLCD {
//-----------methodes -----------------
public:
    /**
     *@brief Constructor, initializes the lcd on the respective pins.
     *@param control pins   DI,RW,E,CS2,CS1
     *@param databus        DB0-DB7    data pins
     *@return none
     */
    GLCD (PinName _DI, PinName _RW, PinName _E, PinName _CS1, PinName _CS2, BusInOut *BUSLCD);
    void setTest(int mode);
    void drawText(int mode);
    void repaint();
    bool isUsed();
    bool getXor();
    void setXor( bool s);
    void init(bool mode);
    void fillScreen( bool color);
    //  void clean( bool h, bool b);
//   void repaint (bool h, bool b);
    void setPixel( unsigned short x, unsigned short y, bool color);
    bool getPixel( unsigned short x, unsigned short y);
    void lineh( unsigned short x0, unsigned short y0,  unsigned short x1, bool color);
    void linev( unsigned short x0, unsigned short y0,  unsigned short y1, bool color);
    void line( unsigned short x1,  unsigned short y1,  unsigned short x2,  unsigned short y2, char dash, bool color);
    void rectangle( unsigned short x1,  unsigned short y1,  unsigned short x2,  unsigned short y2, char dash, bool fill, bool color);
    void bar( unsigned short x1,  unsigned short y1,  unsigned short x2,  unsigned short y2, int width, bool color);
    void circle( unsigned short x,  unsigned short y, unsigned short radius, bool fill, bool color);
    unsigned short ellipse(unsigned short x, unsigned short y,unsigned short  a, unsigned short b, float angle, unsigned short step, bool color);
    unsigned short icon( unsigned short x, unsigned short y, const char* iconptr, bool color, bool  transparency);
    unsigned short text( unsigned short x, unsigned short y, const char* textptr, const char* fontptr, unsigned char size, bool color, bool transparency);
private:
    void reset_pins(int mode);
    void writeByte(unsigned char side, unsigned char data);
    unsigned char readByte(unsigned char side);
    //---------- local variables ----------
private:
    BusInOut*    LCD_PORT;
    DigitalOut   GLCD_DI;
    DigitalOut   GLCD_RW;
    DigitalOut   GLCD_E;
    DigitalOut   GLCD_CS2;
    DigitalOut   GLCD_CS1;
    char left[512];
    char right[512];
    volatile bool isused;
    bool _xor;
    bool ready;
    //-------------------------------------
};
#endif