#ifndef DS1621_H
#define DS1621_H
//------------includes-----------------
#include "mbed.h"
//------------
/**
* DS1621 simple control class,
*
* Example:
* @code
* // Continus temperature acquisition
* #include "mbed.h"
* #include "ds1621.h"
*
* DigitalOut myled1(LED1);
* DigitalOut myled2(LED2);
* DigitalOut myled3(LED3);
* DigitalOut myled4(LED4);
*
* #define DS1621_ADDR 0     // I2c DS1621 address is 0x00
*
* Serial pc(USBTX, USBRX);  // Declare usb (see screen /dev/ttyUSB0 on linux)
* I2C    i2c(p28, p27);     // Declare I2C (pullup resistors 2.2k from p28 and p27 to +3.3v)
* DS1621 ds(&i2c, DS1621_ADDR);  // Declare ds1621 throught i2c interface
*
*int main() {
*    i2c.frequency(5000); //5khz
*    pc.printf("-----------------------\n\rMain\n\r");
*    char count = 0;
*    float temp = 0.0;
*    ds.init(DS1621_ADDR);
*    while (1) {
*        myled1 = count & 0x01;
*        myled2 = count & 0x02;
*        myled3 = count & 0x04;
*        myled4 = count & 0x08;
*        count++;
*        temp = ds.read(DS1621_ADDR);
*        pc.printf("Measurment at start + %d seconds, Temperature=%3.1f\n\r",(count*5),temp);
*        wait(5.0);
*    }
*}
* @endcode
*/
//------------defines------------------
#define DS1621_Write  0x90
#define DS1621_Read   0x91
//------------class--------------------
class DS1621 {
//-----------methodes -----------------
public:
    /**
    *@brief Constructor, initializes the ds1621 on I2C interface.
    *@param interface
    *@param address DS1621 i2c address on bus
    *@return none
    */
    DS1621 (I2C* interface, uint8_t address);

    /**
    *@brief Get temperature as float to the ds1621
    *@param address DS1621 i2c address on bus
    *@return current temperature as a float number in degrees Celsius
    */
    float read(uint8_t address);
    
    /**
    *@brief Initialize DS1621
    *@param address DS1621 i2c address on bus
    *@return none
    */
    void init(uint8_t address);

public:
    bool dbx; // True activate debug message
//---------- local variables ----------
private:
    I2C* i2c; // Communication interface
//-------------------------------------
};
#endif