/***********************************************************
Author: Dupuy Bruno
Date: 5 mars 2001
Version: beta
************************************************************/
#include "ds1621.h"

DS1621::DS1621(I2C* interface, uint8_t address) {
    i2c = interface;
}

float DS1621::read(uint8_t address) { // Return degrees C (-55 to +125)
    if (dbx) printf("DS1621::read DS1621 address=0x%X\n\r",address);
    float temperature = 0.0;
    uint16_t temp16;
    char temp8[2];
    int8_t data;
    if (i2c) {
        address &= 0x0E;
        data = 0xAA; // Read Temperature [AAh]
        i2c->write(DS1621_Write|address,(char *)&data,sizeof(data));
        i2c->read(DS1621_Read|address, temp8 ,sizeof(temp8), false);
        // Format temperature
        temp16 = temp8[0];
        temp16 = temp16 << 1;
        temp16 = temp16 + (temp8[1] >> 7);
        if ((temp16 & 0x100) == 0) { // +
            temperature = ((float) temp16 / 2);
        } else {  // -
            temp16 = ~temp16 & 0xFF;
            temperature = ((float) temp16 / 2);
            temperature = -1.0 * temperature;
        }
        if (dbx) printf("DS1621::read temp8[0]=0x%X, temp8[1]=0x%X, temp16=0x%X\n\r",temp8[0],temp8[1],temp16);
    } else {
        if (dbx) printf("DS1621::read interface I2C is not initialized\n\r");
    }
    return temperature;
}

void DS1621::init(uint8_t address) {
    if (dbx) printf("DS1621::init DS1621 address=0x%X\n\r",address);
    address &= 0x0E;
    char data;
    data = 0xEE; // Start Convert T [EEh]
    i2c->write(DS1621_Write|address,(char *)&data,sizeof(data));
}