cmake_minimum_required(VERSION 3.5)

# Download and unpack hardwareInterface at configure time
configure_file(HardwareInterface.txt.in
               hardwareInterface-download/CMakeLists.txt)

execute_process(COMMAND ${CMAKE_COMMAND} -G "${CMAKE_GENERATOR}" .
  WORKING_DIRECTORY ${CMAKE_BINARY_DIR}/hardwareInterface-download )
execute_process(COMMAND ${CMAKE_COMMAND} --build .
  WORKING_DIRECTORY ${CMAKE_BINARY_DIR}/hardwareInterface-download )
 
# Add hardwareInterface directly to our build.
add_subdirectory(${CMAKE_BINARY_DIR}/hardwareInterface-src
                 ${CMAKE_BINARY_DIR}/hardwareInterface-build)
 
include_directories("${hardwareInterface_SOURCE_DIR}/include")

